package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.json.simple.JSONArray;
import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;
import net.sf.json.JSONObject;



/**
 * 检测手机号是否已经被注册
 * 
 * @author puhui
 *
 */
public class checkUserPhoneIfExist extends TK implements API {
	public String parameter;//参数集合
	public String phone;//手机号

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		phone = MapUtil.getParameter(parameter, "phone").trim();
		
		if ((!phone.equals("")) && phone.equals("code")) {
			parameter = parameter.replace("\"phone\":code", "\"phone\":\""+ phoneNeb + "\"");
		}
		
		phone = MapUtil.getParameter(parameter, "phone").trim();
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_NOtokenNOcookie(data, Url);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功".equals(msg)){
				
				String if_exist=jp.getString("data.if_exist");
				//是否验证数据库
				if (!isProduct) {
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" t_user u ",
								" u.phone = '" + phone + "' ");
						rs_bankcard.last();
						
						String act_phone=rs_bankcard.getString("phone");

						
						if("1".equals(if_exist)){//if_exist=1时代表改手机号已存在
							if (!phone.equals(act_phone)) {
								result = result && false;
								failReason = failReason + "t_user info is not in DB;";
							}
						}else{
							if (phone.equals(act_phone)) {
								result = result && false;
								failReason = failReason + "t_user info is in DB;";
							}
						}
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_user info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
