package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 用户绑定或修改手机号
 * 
 * @author puhui
 *
 */
public class addOrEditPhone extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id;//用户id
	public String phone;//手机

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		phone = MapUtil.getParameter(parameter, "phone").trim();
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		
		if ((!phone.equals("")) && phone.equals("random")) {
			phone="1391"+(new Random().nextInt(9000000)+ 1000000);
			parameter = parameter.replace("\"open_id\":random", "\"open_id\":\""+ phone + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_NOtokenNOcookie(data, Url);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
//			System.out.println(jp.getString("message"));
//			String msg=StringUtils.decodeUnicode(getMsg(re));
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg)){
			
				phoneNeb=phone;
				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" t_user u ",
								" u.user_id = '" + user_id + "' ");
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							String act_phone=rs_bankcard.getString("phone").equals("null ")?"null":rs_bankcard.getString("phone");
							
							parameter = MapUtil.getValue("parameter", data);
							phone = MapUtil.getParameter(parameter, "phone").trim();
							phone = MapUtil.killQuotes(phone, "\"");
							
							if(phone.length()<60){
								if(!(phone.equals(act_phone))){
									result = result && false;
									failReason = failReason + "t_user info phone is not in DB;";
								}
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_user info in DB;";
						e.printStackTrace();
					}
				}
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
