package com.offcn.api.nwn.ht;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.system.MyRequest;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 删除层级或组件
 * 
 * @author wufeifei
 *
 */
public class delOutline extends NWN implements API {
	public String parameter;//参数集合
	
	
	public String template_id;//母版id 
	public String module_type;//组件类型
	public String id_db;//组件id_db
	public String id;//组件id

	@Override
	public void initialize(HashMap<String, Object> data) {
		
		String sql="SELECT id FROM n_template_menu_35 WHERE template_id = 35 AND level_name = \"飞飞飞\" "
				+ "AND deleted_at is NULL ORDER BY id DESC LIMIT 1";
//		
		ResultSet rs_bankcard;
		try {
			rs_bankcard = this.sqlFromDB_template(sql);
			rs_bankcard.last();
			if(rs_bankcard.getRow()>=1){
				id_db=rs_bankcard.getString("id").equals("null ")?"null":rs_bankcard.getString("id");
				System.out.println(id);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		template_id = MapUtil.getParameter_get(parameter, "template_id").trim();
		module_type = MapUtil.getParameter_get(parameter, "module_type").trim();
		id = MapUtil.getParameter_get(parameter, "id").trim();
		
		if ((!template_id.equals("")) && template_id.equals("code")) {
			template_id="35";
			parameter = parameter.replace("template_id=code", "template_id="+ template_id );
		}
		if ((!module_type.equals("")) && module_type.equals("code")) {
			module_type = "0";
			parameter = parameter.replace("module_type=code", "module_type="+ module_type );
		}
		if ((!id.equals("")) && id.equals("code")) {
			parameter = parameter.replace("id=code", "id="+ id_db );
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
//		Response re = RequestDataUtils.Get_two_cookie2(data, Url,"admin_31_encode",admin_31_encode,"PHPSESSID",PHPSESSID);
//		return re;
		Map<String,String> cookies=new HashMap<String,String>();
		cookies.put("admin_31_encode", admin_31_encode);
		cookies.put("PHPSESSID", PHPSESSID);
		cookies.put("admin_login_ssid", admin_login_ssid);
		
		MyRequest myRequest=new MyRequest();
		myRequest.setUrl(Url);
		myRequest.setCookies(cookies);
		myRequest.setRequest(Request);
		
		Response re = RequestDataUtils.RestAssuredApi(data, myRequest);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("更新成功".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					
					parameter = MapUtil.getValue("parameter", data);
					
//					remark = MapUtil.getParameter_get(parameter, "remark").trim();
//					package_id = MapUtil.getParameter_get(parameter, "package_id").trim();
//					intro = MapUtil.getParameter_get(parameter, "intro").trim();
//					cover = MapUtil.getParameter_get(parameter, "cover").trim();
//					pack_name = MapUtil.killQuotes(pack_name, "\"");
//					for_year = MapUtil.killQuotes(for_year, "\"");
//					product = MapUtil.killQuotes(product, "\"");
//					intro = MapUtil.killQuotes(intro, "\"");
//					cover = MapUtil.killQuotes(cover, "\"");
					
					try {
						
//						String sql="select * from n_package where id='"+package_id+"'";
//						
//						ResultSet rs_bankcard = this.sqlFromDB(sql);
//						rs_bankcard.last();
//						
//						if(rs_bankcard.getRow()>=1){
////							
////							
////							String atc_remark=rs_bankcard.getString("remark").equals("null ")?"null":rs_bankcard.getString("remark");
//							String atc_package_id=rs_bankcard.getString("id").equals("null ")?"null":rs_bankcard.getString("id");
//							String act_intro=rs_bankcard.getString("intro").equals("null ")?"null":rs_bankcard.getString("intro");
//							String act_cover=rs_bankcard.getString("cover").equals("null ")?"null":rs_bankcard.getString("cover");
////							
////							System.out.println("atc_remark==" + atc_remark);
//							System.out.println("act_pack_name==" + atc_package_id);
//							System.out.println("act_intro==" + act_intro);
//							System.out.println("act_cover==" + act_cover);
//							/*if(!(remark.equals(atc_remark)) && remark != null && !remark.equals("")){
//									result = result && false;
//									failReason = failReason + "t_exam_area info pack_name is not in DB;";
//							}*/
//							
//						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify n_package info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
