package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 创建学习包
 * 
 * @author puhui
 *
 */
public class createPackage extends NWN implements API {
	public String parameter;//参数集合
	
	public String pack_name;//包名
	public String for_year;//年
	public String product;//平台：1 题库     2  星课堂  3 在线课堂     4 优课',
	public String intro;//介绍
	public String cover;//图片地址

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		pack_name = MapUtil.getParameter(parameter, "pack_name").trim();
		if ((!pack_name.equals("")) && pack_name.equals("random")) {
			pack_name="ys测试"+(new Random().nextInt(9000000)+ 1000000);
			parameter = parameter.replace("\"pack_name\":random", "\"pack_name\":\""+ pack_name + "\"");
		}
		
		for_year = MapUtil.getParameter(parameter, "for_year").trim();
		product = MapUtil.getParameter(parameter, "product").trim();
		intro = MapUtil.getParameter(parameter, "intro").trim();
		cover = MapUtil.getParameter(parameter, "cover").trim();

		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_cooike(data, Url,"PHPSESSID",PHPSESSID);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("success".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					
					parameter = MapUtil.getValue("parameter", data);
					pack_name = MapUtil.getParameter(parameter, "pack_name").trim();
					for_year = MapUtil.getParameter(parameter, "for_year").trim();
					product = MapUtil.getParameter(parameter, "product").trim();
					intro = MapUtil.getParameter(parameter, "intro").trim();
					cover = MapUtil.getParameter(parameter, "cover").trim();
					pack_name = MapUtil.killQuotes(pack_name, "\"");
					for_year = MapUtil.killQuotes(for_year, "\"");
					product = MapUtil.killQuotes(product, "\"");
					intro = MapUtil.killQuotes(intro, "\"");
					cover = MapUtil.killQuotes(cover, "\"");
					
					try {
						
						String sql="select * from n_package where pack_name='"+pack_name+"'";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							
							String act_pack_name=rs_bankcard.getString("pack_name").equals("null ")?"null":rs_bankcard.getString("pack_name");
							String act_for_year=rs_bankcard.getString("for_year").equals("null ")?"null":rs_bankcard.getString("for_year");
							act_for_year=act_for_year.substring(0, 4);
							String act_product=rs_bankcard.getString("product").equals("null ")?"null":rs_bankcard.getString("product");
							String act_intro=rs_bankcard.getString("intro").equals("null ")?"null":rs_bankcard.getString("intro");
							String act_cover=rs_bankcard.getString("cover").equals("null ")?"null":rs_bankcard.getString("cover");
//							String act_package_code=rs_bankcard.getString("package_code").equals("null ")?"null":rs_bankcard.getString("package_code");
							String act_id=rs_bankcard.getString("id").equals("null ")?"null":rs_bankcard.getString("id");
							
							n_package_idList.add(act_id);//
							System.out.println("pack_name==" + pack_name);
							System.out.println("act_pack_name==" + act_pack_name);
							System.out.println("for_year==" + for_year);
							System.out.println("act_for_year==" + act_for_year);
							System.out.println("product==" + product);
							System.out.println("act_product==" + act_product);
							System.out.println("intro==" + intro);
							System.out.println("act_intro==" + act_intro);
							System.out.println("cover==" + cover);
							System.out.println("act_cover==" + act_cover);
							if(!(pack_name.equals(act_pack_name))){
									result = result && false;
									failReason = failReason + "t_exam_area info pack_name is not in DB;";
							}
							if(!(for_year.equals(act_for_year))){
								result = result && false;
								failReason = failReason + "t_exam_area info for_year is not in DB;";
							}
							if(!(product.equals(act_product))){
								result = result && false;
								failReason = failReason + "t_exam_area info product is not in DB;";
							}
							if(!(intro.equals(act_intro))){
								result = result && false;
								failReason = failReason + "t_exam_area info intro is not in DB;";
							}
							
							if(!(cover.equals(act_cover))){
								result = result && false;
								failReason = failReason + "t_exam_area info intro is not in DB;";
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify n_package info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
