package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.ListUtil;
import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 学员管理-学员列表-添加/修改备注
 * 
 * @author puhui
 *
 */
public class addStudentMark extends NWN implements API {
	public String parameter;//参数集合
	
	public String package_id;//学习包id
	public String user_id;//学员id
	public String remarks;//备注
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		package_id = MapUtil.getParameter_get(parameter, "package_id").trim();
		user_id = MapUtil.getParameter_get(parameter, "user_id").trim();
		remarks = MapUtil.getParameter_get(parameter, "remarks").trim();
		
		if ((!package_id.equals("")) && package_id.equals("code")) {
			package_id=ListUtil.getListValue(n_package_idList, 0);
			parameter = parameter.replace("package_id=code", "package_id="+ package_id );
		}
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_id_List, 0);
			parameter = parameter.replace("user_id=code", "user_id="+ user_id );
		}
		if ((!remarks.equals("")) && remarks.equals("random")) {
			remarks="1391"+(new Random().nextInt(9000000)+ 1000000);
			parameter = parameter.replace("remarks=random", "remarks="+ remarks );
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		
		Response re = RequestDataUtils.Get_one_cookie_pre(data, Url, "PHPSESSID",PHPSESSID);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
//				System.out.println(jp.getString("custom"));
//				System.out.println(Arrays.toString(ArrayString));
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			
			if("0".equals(jp.getString("retcode"))){
				
				//是否验证数据库
				if (!isProduct) {
					
//					try {
//						String sql="select  *  from  n_user  where id='"+user_id+"'";
//						
//						ResultSet rs_bankcard = this.sqlFromDB(sql);
//						rs_bankcard.last();
//						
//						user_id_List.add(rs_bankcard.getString("id"));
//						
//					} catch (Exception e) {
//						result = result && false;
//						failReason = failReason + "cannot verify n_package info in DB;";
//						e.printStackTrace();
//					}
				}
			}
			
			
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
