package com.offcn.TestUnti;

/**
 * Created by puhui on 2016/8/1.
 */
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.Security;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class AES256Encryption {

    // 解密
    private static final BASE64Decoder DECODER = new BASE64Decoder();

    // 加密
    private static final BASE64Encoder ENCODER = new BASE64Encoder();

    private final static byte[] hex = "0123456789ABCDEF".getBytes();

    /**
     * 密钥算法 java6支持56位密钥，bouncycastle支持64位
     * */
    public static final String KEY_ALGORITHM = "AES";

    public static final byte[] AES_PASSWORD_TEXT = "puhui88888888888".getBytes();

    /**
     * 加密/解密算法/工作模式/填充方式
     *
     * JAVA6 支持PKCS5PADDING填充方式 Bouncy castle支持PKCS7Padding填充方式
     * */
    public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    /**
     *
     * 生成密钥，java6只支持56位密钥，bouncycastle支持64位密钥
     *
     * @return byte[] 二进制密钥
     * */
    public static byte[] initkey() throws Exception{
        //实例化密钥生成器
        Security.addProvider(new  org.bouncycastle.jce.provider.BouncyCastleProvider());
        KeyGenerator kg=KeyGenerator.getInstance(KEY_ALGORITHM, "BC");
        //初始化密钥生成器，AES要求密钥长度为128位、192位、256位
        kg.init(256);
//	 kg.init(128);
        //生成密钥
        SecretKey secretKey=kg.generateKey();
        //获取二进制密钥编码形式
        return secretKey.getEncoded();
        // 为了便于测试，这里我把key写死了，如果大家需要自动生成，可用上面注释掉的代码
//	 return new byte[] { 0x08, 0x08, 0x04, 0x0b, 0x02, 0x0f, 0x0b, 0x0c,
//	 0x01, 0x03, 0x09, 0x07, 0x0c, 0x03, 0x07, 0x0a, 0x04, 0x0f,
//	 0x06, 0x0f, 0x0e, 0x09, 0x05, 0x01, 0x0a, 0x0a, 0x01, 0x09,
//	 0x06, 0x07, 0x09, 0x0d };
        // return AES_PASSWORD_TEXT.getBytes();
    }

    /**
     * 转换密钥
     *
     * @param key
     *            二进制密钥
     * @return Key 密钥
     * */
    public static Key toKey(byte[] key) throws Exception {
        // 实例化DES密钥
        // 生成密钥
        SecretKey secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        return secretKey;
    }

    /**
     * 加密数据
     *
     * @param data       待加密数据
     * @return String 加密后的数据
     * */
    public static String encrypt(byte[] data)  {
        try{
            // 还原密钥
            Key k = toKey(AES_PASSWORD_TEXT);
            /**
             * 实例化 使用 PKCS7PADDING 填充方式，按如下方式实现,就是调用bouncycastle组件实现
             * Cipher.getInstance(CIPHER_ALGORITHM,"BC")
             */
            // Security.addProvider(new
            // org.bouncycastle.jce.provider.BouncyCastleProvider());
            // Cipher cipher=Cipher.getInstance(CIPHER_ALGORITHM, "BC");
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            // 初始化，设置为加密模式
            cipher.init(Cipher.ENCRYPT_MODE, k);
            // 执行操作
            byte[] aesData = cipher.doFinal(data);

            return ENCODER.encode(aesData);//bass64加密
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }

    /**
     * AES解密数据
     *
     * @param data
     *            待解密数据
     * @return String 解密后的数据
     * */
    public static String decrypt(String data) throws Exception {

        // 欢迎密钥
        Key k = toKey(AES_PASSWORD_TEXT);

        byte[] deData = DECODER.decodeBuffer(data);
        /**
         * 实例化 使用 PKCS7PADDING 填充方式，按如下方式实现,就是调用bouncycastle组件实现
         * Cipher.getInstance(CIPHER_ALGORITHM,"BC")
         */
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        // 初始化，设置为解密模式
        cipher.init(Cipher.DECRYPT_MODE, k);
        // 执行操作
        byte[] aa = cipher.doFinal(deData);// 十六进制
        return new String(aa);
    }

    /**
     * 将16进制数组转换成字符串
     *
     * @Description:
     * @Title: parseHexStr2Byte
     * @user: ningyijie
     * @return: String
     */
    public static String parseHexStr2Byte(byte[] b) {
        byte[] buff = new byte[2 * b.length];
        for (int i = 0; i < b.length; i++) {
            buff[2 * i] = hex[(b[i] >> 4) & 0x0f];
            buff[2 * i + 1] = hex[b[i] & 0x0f];
        }
        return new String(buff);
    }

    /**
     * @param args
     * @throws UnsupportedEncodingException
     * @throws Exception
     */
    public static void main(String[] args) throws UnsupportedEncodingException {
        String str = "appid=tiku&nickname=wangzhipeng&user_id=16&123456";
        System.out.println("原文：" + str);
        try {
            // 加密数据
            String data = AES256Encryption.encrypt(str.getBytes());
            System.out.println("aes加密后："+data);
            // 解密
            String aa = AES256Encryption.decrypt("+RRDgv8Dst9RyN9E0XKPAA=");
            System.out.println("aes解密后：" + aa);

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }
}

