/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.dbunit.database.statement.IBatchStatement;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStatementDecorator
implements IPreparedBatchStatement {
    private static final Logger logger = LoggerFactory.getLogger(BatchStatementDecorator.class);
    private final IBatchStatement _statement;
    private final String[] _sqlTemplate;
    private StringBuffer _sqlBuffer;
    private int _index;

    BatchStatementDecorator(String sql, IBatchStatement statement) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(sql, "?");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (sql.endsWith("?")) {
            list.add("");
        }
        this._sqlTemplate = list.toArray(new String[0]);
        this._statement = statement;
        this._index = 0;
        this._sqlBuffer = new StringBuffer(this._sqlTemplate[this._index++]);
    }

    public void addValue(Object value, DataType dataType) throws TypeCastException, SQLException {
        logger.debug("addValue(value={}, dataType={}) - start", value, (Object)dataType);
        this._sqlBuffer.append(DataSetUtils.getSqlValueString(value, dataType));
        this._sqlBuffer.append(this._sqlTemplate[this._index++]);
    }

    public void addBatch() throws SQLException {
        logger.debug("addBatch() - start");
        this._statement.addBatch(this._sqlBuffer.toString());
        this._index = 0;
        this._sqlBuffer = new StringBuffer(this._sqlTemplate[this._index++]);
    }

    public int executeBatch() throws SQLException {
        logger.debug("executeBatch() - start");
        return this._statement.executeBatch();
    }

    public void clearBatch() throws SQLException {
        logger.debug("clearBatch() - start");
        this._statement.clearBatch();
        this._index = 0;
        this._sqlBuffer = new StringBuffer(this._sqlTemplate[this._index++]);
    }

    public void close() throws SQLException {
        logger.debug("close() - start");
        this._statement.close();
    }
}

