/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.adapter;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.remote.SlavePool;
import org.testng.internal.thread.ThreadUtil;
import org.testng.remote.RemoteSuiteWorker;
import org.testng.remote.adapter.IMasterAdapter;
import org.testng.remote.adapter.RemoteResultListener;
import org.testng.xml.XmlSuite;

public class DefaultMastertAdapter
implements IMasterAdapter {
    public static final String HOSTS = "testng.hosts";
    private String[] m_hosts;
    private final SlavePool m_slavePool = new SlavePool();
    private final List<Runnable> m_workers = Lists.newArrayList();

    @Override
    public void init(Properties properties) {
        String hostLine = properties.getProperty(HOSTS);
        this.m_hosts = hostLine.split(" ");
        Socket[] sockets = new Socket[this.m_hosts.length];
        for (int i = 0; i < this.m_hosts.length; ++i) {
            String host = this.m_hosts[i];
            String[] s = host.split(":");
            try {
                sockets[i] = new Socket(s[0], Integer.parseInt(s[1]));
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace(System.out);
                continue;
            }
            catch (UnknownHostException e) {
                e.printStackTrace(System.out);
                continue;
            }
            catch (IOException e) {
                Utils.error("Couldn't connect to " + host + ": " + e.getMessage());
            }
        }
        try {
            this.m_slavePool.addSlaves(sockets);
        }
        catch (IOException e1) {
            e1.printStackTrace(System.out);
        }
    }

    @Override
    public void runSuitesRemotely(XmlSuite suite, RemoteResultListener listener) throws IOException {
        this.m_workers.add(new RemoteSuiteWorker(suite, this.m_slavePool, listener));
    }

    @Override
    public void awaitTermination(long timeout) throws InterruptedException {
        ThreadUtil.execute(this.m_workers, 1, 10000L, false);
    }
}

