
func (m *default{{.upperStartCamelObject}}Model) FindOne(ctx context.Context, {{.lowerStartCamelPrimaryKey}} {{.dataType}}) (*{{.upperStartCamelObject}}, error) {
	{{if .withCache}}{{.cacheKey}}
	var resp {{.upperStartCamelObject}}
	err := m.QueryCtx(ctx, &resp, {{.cacheKeyVariable}}, func(conn *gorm.DB, v interface{}) error {
    		return conn.Model(&{{.upperStartCamelObject}}{}).Where("{{.originalPrimaryKey}} = ?", {{.lowerStartCamelPrimaryKey}}).First(&resp).Error
    	})
	if err == nil {
		return &resp, nil
	} else if errors.Is(err, gorm.ErrRecordNotFound) {
		return nil, nil
	} else {
		return nil, err
	}{{else}}var resp {{.upperStartCamelObject}}
	err := m.conn.WithContext(ctx).Model(&{{.upperStartCamelObject}}{}).Where("{{.originalPrimaryKey}} = ?", {{.lowerStartCamelPrimaryKey}}).Take(&resp).Error
	if err == nil {
		return &resp, nil
	} else if errors.Is(err, gorm.ErrRecordNotFound) {
		return nil, nil
	} else {
		return nil, err
	}{{end}}
}

func (m *default{{.upperStartCamelObject}}Model) First(ctx context.Context, condition interface{}, columns []string, order string) (*{{.upperStartCamelObject}}, error) {
    {{if .withCache}}{{.cacheKey}}
	var resp {{.upperStartCamelObject}}
	err := m.QueryCtx(ctx, &resp, {{.cacheKeyVariable}}, func(conn *gorm.DB, v interface{}) error {
	    db := conn.Model(&{{.upperStartCamelObject}}{})
        if len(columns) > 0 {
            db = db.Select(columns)
        }

        if order != "" {
            db = db.Order(order)
        }

        return db.First(&resp, condition).Error
    })
    if err == nil {
        return &resp, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return nil, nil
    } else {
        return nil, err
    }
	{{else}}var resp {{.upperStartCamelObject}}
    db := m.conn.WithContext(ctx).Model(&{{.upperStartCamelObject}}{})
    if len(columns) > 0 {
        db = db.Select(columns)
    }

    if order != "" {
        db = db.Order(order)
    }

    err := db.First(&resp, condition).Error
    if err == nil {
        return &resp, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return nil, nil
    } else {
        return nil, err
    }{{end}}
}

func (m *default{{.upperStartCamelObject}}Model) Find(ctx context.Context, where interface{}, columns []string, order string) ([]*{{.upperStartCamelObject}}, error) {
    {{if .withCache}}{{.cacheKey}}
	var resp []*{{.upperStartCamelObject}}
	err := m.QueryCtx(ctx, &resp, {{.cacheKeyVariable}}, func(conn *gorm.DB, v interface{}) error {
	    db := conn.Model(&{{.upperStartCamelObject}}{})
        if len(columns) > 0 {
            db = db.Select(columns)
        }

        if order != "" {
            db = db.Order(order)
        }

        return db.Find(&resp, where).Error
    })
    if err == nil {
        return resp, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return nil, nil
    } else {
        return nil, err
    }
	{{else}}var resp []*{{.upperStartCamelObject}}
    db := m.conn.WithContext(ctx).Model(&{{.upperStartCamelObject}}{})
    if len(columns) > 0 {
        db = db.Select(columns)
    }

    if order != "" {
        db = db.Order(order)
    }

    err := db.Find(&resp, where).Error
    if err == nil {
        return resp, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return nil, nil
    } else {
        return nil, err
    }{{end}}
}

func (m *default{{.upperStartCamelObject}}Model) Count(ctx context.Context, where interface{}) (int64, error) {
    {{if .withCache}}{{.cacheKey}}
	var count int64
	err := m.QueryCtx(ctx, &count, {{.cacheKeyVariable}}, func(conn *gorm.DB, v interface{}) error {
	    return conn.Model(&{{.upperStartCamelObject}}{}).Where(where).Count(&count).Error
    })
    if err == nil {
        return count, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return 0, nil
    } else {
        return 0, err
    }
	{{else}}var count int64
    err := m.conn.WithContext(ctx).Model(&{{.upperStartCamelObject}}{}).Where(where).Count(&count).Error
    if err == nil {
        return count, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return 0, nil
    } else {
        return 0, err
    }{{end}}
}

func (m *default{{.upperStartCamelObject}}Model) Paginate(ctx context.Context, where interface{}, columns []string, order string, page int, pageSize int) ([]*{{.upperStartCamelObject}}, int64, error) {
    {{if .withCache}}{{.cacheKey}}
    pagination := struct {
        List  []*UpWorkTags
        Total int64
    }{}

	err := m.QueryCtx(ctx, &pagination, {{.cacheKeyVariable}}, func(conn *gorm.DB, v interface{}) error {
	    db := conn.Model(&{{.upperStartCamelObject}}{})
        if len(columns) > 0 {
            db = db.Select(columns)
        }

        if order != "" {
            db = db.Order(order)
        }
        err := db.Count(&pagination.Total).Error
        if err == nil {
            return err
        }

        if page == 0 {
            page = 1
        }
        if pageSize > 500 {
            pageSize = 500
        } else if pageSize <= 0 {
            pageSize = 10
        }

        offset := (page - 1) * pageSize
        db = db.Offset(offset).Limit(pageSize)
        return db.Find(&pagination.List, where).Error
    })
    if err == nil {
        return pagination.List, pagination.Total, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return nil, 0, nil
    } else {
        return nil, 0, err
    }
	{{else}}
    var list []*{{.upperStartCamelObject}}
    var total int64

    db := m.conn.WithContext(ctx).Model(&{{.upperStartCamelObject}}{})
    if len(columns) > 0 {
        db = db.Select(columns)
    }

    if order != "" {
        db = db.Order(order)
    }
    err := db.Count(&total).Error
    if err == nil {
        return list, total, nil
    }

    if page == 0 {
        page = 1
    }
    if pageSize > 500 {
        pageSize = 500
    } else if pageSize <= 0 {
        pageSize = 10
    }

    offset := (page - 1) * pageSize
    db = db.Offset(offset).Limit(pageSize)
    err = db.Find(&list, where).Error
    if err == nil {
        return list, total, nil
    } else if errors.Is(err, gorm.ErrRecordNotFound) {
        return nil, 0, nil
    } else {
        return nil, 0, err
    }{{end}}
}