package {{.PkgName}}

import (
	"net/http"
	"reflect"

	"github.com/zeromicro/go-zero/rest/httpx"
	{{.ImportPackages}}
	"user-portrait/userportrait/common/validator"
	"user-portrait/userportrait/common/errorx"
)

func {{.HandlerName}}(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		{{if .HasRequest}}var req types.{{.RequestType}}
		if err := httpx.Parse(r, &req); err != nil {
			httpx.Error(w, errorx.NewErrCodeMsg(http.StatusBadRequest, err.Error()))
			return
		}

		if err := svcCtx.Validate.StructCtx(r.Context(), &req); err != nil {
			httpx.Error(w, errorx.NewErrCodeMsg(http.StatusBadRequest, validator.FormatValidateError(err, &req)))
			return
		}

		{{end}}l := {{.LogicName}}.New{{.LogicType}}(r.Context(), svcCtx)
		{{if .HasResp}}resp, {{end}}err := l.{{.Call}}({{if .HasRequest}}&req{{end}})
		if err != nil {
			httpx.Error(w, err)
		} else {
			typ := reflect.TypeOf(resp)
			if typ.Kind() == reflect.String {
				_, _ = w.Write([]byte(resp))
				httpx.Ok(w)
			} else {
				{{if .HasResp}}httpx.OkJson(w, resp){{else}}httpx.Ok(w){{end}}
			}	
		}
	}
}
