<?php
/**
 * 权限分类管理
 */

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PrivilegeController extends Controller
{
    /**
     * 应用类型列表
     * @param String $type_name 应用类型名称
     * @return Json $result 响应结果
     */
    public function index(Request $request)
    {
        $url = getRbac($request,'api/open/check');

        $data['appid'] = $request->appid;
        $data['uid'] = Auth::user()->mis_uid;
        $data['tree'] = 1;


        $result = http_request_code($url,
            null,
            'GET',
            $data
        );

        $result = json_decode($result,true);

        if (empty($result['data'])){
            return view('admin.nodata',$data);
        }

        $url = getRbac($request);
        $data['url'] = $url;
        return view('admin.privilege.list',$data);
    }

}
