<?php

namespace App\Http\Controllers\Api;

use App\Exceptions\FormException;
use App\Model\MediaModel;
use App\Model\QiniuModel;
use App\Tool\Constant;
use App\Tool\SrsHookValidate;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use MongoBinData;

use MongoDB\BSON\UTCDateTime;
use Qiniu\Auth;

class MediaController extends Controller
{

    /**
     * 获取媒资ID
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function media_list(Request $request){

        $result = handler_drive(function () use ($request){

            SrsHookValidate::srsHookCallback($request,[
                'params'    => 'required'
            ]);

            return MediaModel::getMediaList($request);

        });

        return success($result);
    }

    /**
     * 获取媒资播放地址
     * @param Request $request
     * @param $media_id
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function play_url(Request $request,$media_id){

        $result = handler_drive(function () use ($request,$media_id){
            return MediaModel::playUrl($media_id);
        });

        return success($result);

    }



    /**
     * 获取媒资列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function mediaListOnce(Request $request){

        $res = handler_drive(function () use($request){

            SrsHookValidate::srsHookCallback($request,[
                'page'          => 'integer',
                'sort'          => '',
                'page_size'     => 'integer',
                'start_time'    => 'date',
                'end_time'      => 'date',
                'category_id'   => ''
            ]);

            if (!isset($request->category_id)){
                $request->replace(array_merge($request->all(),['category_id'=>'5efa9cb5d16f5a214671fd86']));
            }

            return MediaModel::mediaList($request);

        });

        return success($res);
    }


    public function test(Request $request){

        $res = [];

        for ($i = 0;$i<=5;$i++){

            $url = "http://eoffcn.com/api/user/media_list_once?page=".$i.'&page_size=1000';
            $result = http_request_code($url,null,'GET');

            $medias = json_decode($result,true);

            if (isset($medias['data']['data']) && !empty($medias['data']['data'])){

                $data = $medias['data']['data'];


                if (!empty($data)){

                    foreach ($data as $media){
                        $tmp_arr = MediaModel::where("media_name",$media['media_name'])->where("media_type_id","5efa9ca25b742508e81f2d55")->get();
                        if (count($tmp_arr)>=2){

                            var_dump($media);
                            MediaModel::deleteMediaById($request,$media["_id"]);

                        }

                    }
                }

            }
            echo "sleep";

        }

        return success($res);

    }





    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function handleMediaUrl(Request $request){

        $res = handler_drive(function () use($request){
            SrsHookValidate::srsHookCallback($request,[
                'media_name'    => '',
                'username'      => '',
                'page'          => 'integer',
                'media_id'      => '',
                'description'   => '',
                'sort'          => '',
                'page_size'     => 'integer',
            ]);
            return MediaModel::handleMediaUrl($request);
        });
        return success($res);
    }


    /**
     * 视频上传成功之后，回调重新上传
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function hookRestoreMedia(Request $request){

        $id = handler_drive(function () use ($request) {

            SrsHookValidate::srsHookCallback($request,array_merge([
                'media_name'  => 'required',
                'secret_key'  => '',
                'media_url'   => 'required',
                'description' => '',
                'duration'    => '',
                'media_type'  => '',
                'shop_id'     => '',
            ]));

            $data_time = Carbon::now();


            $params = array(
                'media_id'  => 'mda-'.generateRandomNum(16),
                'media_type'=> '5efa9cb5d16f5a214671fd86',//默认，中公网校
                'start_time'=> $data_time,
                'end_time'  => $data_time,
                'access_key'=> '',
                'description'=>$request->description??'',
            );



            if ($request->shop_id=='100'){
                $params['media_type'] = "5f3d073a033f5a336b2b4346";
            }

            $request->replace(array_merge($request->all(),$params));

            $id = MediaModel::hookRestoreMedia($request);

            return $id;
        });
        return success($id);
    }

    /**
     * 更新百度status
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function updateMediaStatus(Request $request,$media_id){


        $id = handler_drive(function () use ($request,$media_id) {

            SrsHookValidate::srsHookCallback($request,[
                'status'    => '',
                'secret_key'  => '',
                'media_url'   => '',
            ],function ($items){

                $request = $items;

                if ($request->status){

                    if (!$request->media_url || !$request->secret_key){
                        throw new FormException("参数缺失");
                    }
                }

            });

            $id = MediaModel::updateMediaStatus($request,$media_id);

            return $id;
        });
        return success($id);

    }

    /**
     * 更新数据日期
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function updateDatetime(Request $request){

        $id = handler_drive(function () use ($request) {

            $id = MediaModel::updateDatetime($request);

            return $id;
        });
        return success($id);

    }


}
