<!DOCTYPE html>
<html>

@include('admin.common.commonMedia')


<link rel="stylesheet" href="{{ asset('xadmin/extra/datepicker/css/daterangepicker.css')}}">
<link rel="stylesheet" href="{{ asset('xadmin/extra/datepicker/css/htmleaf-demo.css')}}">

<script src="{{ asset('xadmin/extra/datepicker/js/moment.js')}}"></script>
<script src="{{ asset('xadmin/extra/datepicker/js/daterangepicker.js')}}"></script>
<body>

<!--====================================================
                         MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                        PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner chart-cont">

        <div class="card form">
            <div class="card-header">
                <h3>媒资类别列表</h3>
            </div>
            <br>

            <!--***** CONTENT *****-->
            <div class="row ml20">
                <div class="xblock">

                    <button class="btn btn-primary" onclick="x_admin_show('/web/media_category/create')">
                        添加
                    </button>

                    <form>
                        <input type="text" name="name" class="form-input" placeholder="类别名称" value="{{$name}}" autocomplete="off">
                        <button type="submit" class="btn btn-primary">搜索</button>
                    </form>
                    <span  style="display: inline-block;height: 40px;line-height: 40px; float: right">共{{$media_categories->total()}}条</span>
                </div>

                <table class="table table-hover">
                    <thead>
                    <tr class="bg-info text-white">
                        <th>序号</th>
                        <th>类别编号</th>
                        <th>类别名称</th>
                        <th>状态</th>
                        <th>操作</th>
                    </tr>
                    </thead>
                    <tbody>

                    @if(count($media_categories)>0)
                        @foreach ($media_categories as $key => $media_category)
                            <tr class="<?php if($key%2==0) echo 'table-success';?>">
                                <td>{{$key+1}}</td>
                                <td style="max-width: 150px;">{{$media_category['_id']}}</td>
                                <td>{{$media_category['name']}}</td>
                                <td>
                                    @if($media_category['status']==0)
                                        启用
                                    @else
                                        停用
                                    @endif
                                </td>
                                <td class="td-manage">
                                    <a onclick="member_stop(this,'{{$media_category["_id"]}}')" href="javascript:;" status="{{$media_category['status']}}">
                                        <i class="iconfont">@if( $media_category['status'] == 1 ) &#xe79e;@else&#xe689;@endif</i>
                                    </a>
                                    <a title="编辑" href="/web/media_category/{{$media_category['_id']}}/edit">
                                        <i class="iconfont">&#xe609;</i>
                                    </a>
                                    {{--<a onclick="x_admin_show('修改密码','/web/password/{{$user->id}}',500,300)" title="修改密码"--}}
                                    {{--href="javascript:;">--}}
                                    {{--<i class="iconfont">&#xe61a;</i>--}}
                                    {{--</a>--}}
                                    <a title="删除" onclick="member_del(this,'{{$media_category["_id"]}}')" href="javascript:;">
                                        <i class="iconfont">&#xe695;</i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="9" style="text-align:center">暂无数据</td>
                        </tr>
                    @endif
                    </tbody>
                </table>

                <div class="page">
                    <div>
                        {{$media_categories->appends(['name'=>$name])->links()}}
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')

<!--Core Javascript -->
<link rel="stylesheet" href="{{ asset('xadmin/extra/jqueryConfirm/css/jquery-confirm.css')}}">
<script src="{{ asset('xadmin/extra/jqueryConfirm/js/jquery-confirm.min.js')}}"></script>

<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

<script type="text/javascript">

    function x_admin_show(url){
        window.location.href = url;
    }

    function member_del(row,id){


        $.confirm({
            // confirmButtonClass: 'btn-info',
            // cancelButtonClass: 'btn-info',
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            content:'确认要刪除吗？',
            confirmButton:'确认',
            cancelButton:'取消',


            confirm: function () {
                fetch_response('DELETE',"/web/media_category/"+id).then(function (res) {
                    if (res.code==200) {
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                        setTimeout(function () {
                            window.location.href='/web/media_category';
                        },2000)
                    }else{
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                    }
                })

            },
            cancel: function () {
                $('body').toast({
                    position:'fixed',
                    content:'已取消',
                    duration:1000,
                    top:'50%'
                });
            }
        });
    }


    function member_stop(obj,id){

        var status = $(obj).attr('status');
        var opts = new FormData();
        var title = "停用";
        opts.append('_token', "{{csrf_token()}}")

        if (status == '1'){
            title = "开启";
        }


        $.confirm({
            // confirmButtonClass: 'btn-info',
            // cancelButtonClass: 'btn-info',
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            content:'确认要'+title+'吗？',
            confirmButton:'确认',
            cancelButton:'取消',

            confirm: function () {

                if(title == '停用'){
                    //发异步把用户状态进行更改
                    opts.append('id',id);
                    opts.append('status',1);
                    fetch_response('POST','/web/media_category/disable',opts).then(function(res){
                        if(res.code == 200){
                            $(obj).attr('title','启用')
                            $(obj).find('i').html('&#xe79e;');
                            $(obj).parents("tr").find(".td-status").find('span').addClass('layui-btn-disabled').html('已停用');

                            $('body').toast({
                                position: 'fixed',
                                content: '已停用',
                                duration: 1000,
                                top: '50%'
                            });
                            setTimeout(function () {
                                window.location.href = '/web/media_category';
                            }, 2000)


                        }else{
                            $('body').toast({
                                position: 'fixed',
                                content: res.msg,
                                duration: 1000,
                                top: '50%'
                            });
                        }
                    });
                }else{
                    opts.append('id',id);
                    opts.append('status',0);
                    fetch_response('POST','/web/media_category/disable',opts).then(function(res){
                        if(res.code == 200){
                            $(obj).attr('title','停用')
                            $(obj).find('i').html('&#xe689;');

                            $(obj).parents("tr").find(".td-status").find('span').removeClass('layui-btn-disabled').html('已启用');
                            // layer.msg('已启用!',{icon: 6,time:1000},function(){
                            //     window.location.reload();
                            // });

                            $('body').toast({
                                position: 'fixed',
                                content: '已启用',
                                duration: 1000,
                                top: '50%'
                            });
                            setTimeout(function () {
                                window.location.href = '/web/media_category';
                            }, 2000)
                        }else{
                            $('body').toast({
                                position: 'fixed',
                                content: res.msg,
                                duration: 1000,
                                top: '50%'
                            });
                        }
                    });

                }

            },
            cancel: function () {
                $('body').toast({
                    position: 'fixed',
                    content: '已取消',
                    duration: 1000,
                    top: '50%'
                });
            }
        });

    }
</script>

</body>

</html>