<!DOCTYPE html>
<html>
@include('admin.common.commonMedia')

<link rel="stylesheet" href="{{asset('xadmin/extra/date/datepicker.css')}}">
<script src="{{ asset('xadmin/extra/date/datepicker.js')}}"></script>
<script src="{{ asset('xadmin/extra/date/datepicker.zh-CN.js')}}"></script>
<body>

<!--====================================================
                         MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                        PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner chart-cont">

        <div class="card form">
            <div class="card-header">
                <h3><i class="fa fa-user-circle"></i> 批处理</h3>
            </div>
            <br>

            <!--***** CONTENT *****-->
            <div class="row ml20 batch-list">

                <form action="{{ asset('/web/media_manager/import_batch_media') }}" method="post" enctype="multipart/form-data">
                    {{ method_field('POST')}}

                    <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                    <div class="item-name">批量导出预览视频连接</div>

                    <div class="form-group">
                        <input type="file" class="btn btn-info" id="uploadFile" name="uploadFile" accept=".xls,.xlsx">
                    </div>
                    <button class="btn btn-info batch-media" type="submit" id="batch-media" disabled >提交</button>

                </form>

            </div>
        </div>

    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')

<!--Core Javascript -->
<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>


<style>
    .form{
        min-height: 734px;
    }
    .batch-list{
        font-size: 18px;
        font-weight: 400;
    }
    .batch-media{
        margin-top: 10px;
    }
</style>
<script>
    /**
     * 点击上传文件，触发input type="file"
     */
    $("#uploadFile").change(function () {
        $("#batch-media").removeAttr("disabled");
        var fileInput = $('#uploadFile').get(0).files[0];
        if (fileInput === undefined){
            $("#batch-media").attr("disabled",true);
        }
    })


</script>

</body>

</html>