//var baseurl = 'http://local.www.nxxadmin.com';
//var baseurl = 'http://39.105.38.33';
/**
 * fetch提交
 * @param method,url,opts
 * @return response json
 */
function fetch_response(method,url,opts='',header={})
{
    param = {
        method:method,
        credentials: "include",
    }
    if (header) {
        param.headers = header;
    } else {
        param.headers = {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
        };
    }
    if (method != 'GET') {
        param['body'] = opts
    }
    return Promise.race([
        fetch(url,param),
        new Promise(function (resolve,reject) {
            setTimeout(function () {
                reject(new Error('request timeout'))
            },10000)
        })
    ]).then(function (response) {
        return response.json();
    }).catch(function (err) {
        //alert(err);
        return {"code":5,"msg":"远程服务器请求失败"};
    }).then(function (myJson) {
        return myJson;
    });
}

function formatDateTime(inputTime) {
    var date = new Date(inputTime);
    var y = date.getFullYear();
    var m = date.getMonth() + 1;
    m = m < 10 ? ('0' + m) : m;
    var d = date.getDate();
    d = d < 10 ? ('0' + d) : d;
    var h = date.getHours();
    h = h < 10 ? ('0' + h) : h;
    var minute = date.getMinutes();
    var second = date.getSeconds();
    minute = minute < 10 ? ('0' + minute) : minute;
    second = second < 10 ? ('0' + second) : second;
    return y + '-' + m + '-' + d + ' ' + h + ':' + minute + ':' + second;
};