<?php
/**
 * Created by PhpStorm.
 * User: nxtvadmin
 * Date: 2018/7/17
 * Time: 11:28
 * 会用路由
 */

namespace App\Http\Routes\Web;
use Illuminate\Contracts\Routing\Registrar;

class MediaRoute extends AuthenRoute
{
    public function map(Registrar $router,$callback){
        parent::map($router,function() use ($router){
            $router->resource('media_model','MediaController');
            $router->get('media_command','MediaController@media_command');
            $router->get('video_preview/{media_num}','MediaController@media_preview');
            $router->post('set_media_num','MediaController@setMediaNum');
            $router->get('clear_cdn_cache/{media_id}','MediaController@clearCdnCache');

            #导入待处理media编号excel表格
            $router->post('media_manager/import_batch_media','MediaController@import_batch_media');
            #展示批处理页面
            $router->get('media_manager/batch_media','MediaController@batch_media');

            #导出展示批处理
            $router->get('media_manager/export_batch_media','MediaController@export_batch_media');



        });

    }
}