<?php

namespace App\Exports;

use App\Model\MediaModel;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;

class MediasExport implements WithHeadings,FromArray
{
    use Exportable;

    public function __construct($params)
    {
        $this->media_ids = $params;
    }

    /**
     * 设置表头
     * @return array
     */
    public function headings(): array
    {
        return [
            '媒资编号',
            '视频名称',
            "永久播放地址",
            "预览地址",
            "全屏预览地址"
        ];
    }

    public function array(): array
    {
        return $this->media_ids;
    }
}
