<?php

namespace App\Exceptions;

use Exception;
use App\Tool\ToolFunc;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;

class Handler extends ExceptionHandler
{
    use ToolFunc;
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * This is a great spot to send exceptions to Sentry, Bugsnag, etc.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {
        if (!self::handlerException($exception)) {
            parent::report($exception);
        }
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {

        $path = $request->path();

//        var_dump($exception->getMessage());
//        var_dump($exception->getFile());
//        var_dump($exception->getLine());


        #检测当前请求是否是api路由
        if (stripos($path,'api/') === 0
                && ($exception instanceof  \Symfony\Component\HttpKernel\Exception\NotFoundHttpException) ) {
            return error('resources not found',\Symfony\Component\HttpFoundation\Response::HTTP_NOT_FOUND);
        }

        if( ( (stripos($path,'web/') === 0 && strrpos($path,'.php') !== false) || (stripos($path,'web/') === 0 && strrpos($path,'.html') !== false ) ) && ($exception instanceof  \Symfony\Component\HttpKernel\Exception\NotFoundHttpException) ) {
            if (view()->exists('errors.404')) {
                return response()->view('errors.404');
            }
        }

        if (self::handlerException($exception)) {
            # 获取常量类里面的异常常量
            $message = json_decode($exception->getMessage(),true);
            return error(...$message);
        } else if ($exception instanceof AuthenticationException) {
            return error($exception->getMessage(),\Symfony\Component\HttpFoundation\Response::HTTP_UNAUTHORIZED);
        } else if ($exception instanceof \Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException) {
            return error('请求方法不被允许',\Symfony\Component\HttpFoundation\Response::HTTP_METHOD_NOT_ALLOWED);
        } else if ($exception instanceof \Symfony\Component\HttpKernel\Exception\HttpException) {
            if ($exception->getMessage() == 'Too Many Attempts.') {
                return error('请求接口过于频繁',429);
            }

        }else if($exception instanceof \RedisException){
            return error('redis连接异常');
        }

        if ($request->is('api/*')) {
            return error('服务器请求异常:'.$exception->getMessage()."异常信息详情:".$exception->getTraceAsString(),500);
        } else {

            if ($exception->getMessage() != '') {
                //print_r($exception->getMessage());
                if ($exception->getMessage() == 403) {
                    return response()->view('errors.403');
                }

                return response()->view('errors.404');
            }
            #return response()->json(['code'=>403, 'msg'=>'您没有权限']);
        }
       return parent::render($request, $exception);
    }
}
