<!DOCTYPE html>
<html>

@include('admin.common_bak.commonMedia')

<body>

<!--====================================================
                         MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                        PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner chart-cont">

        <div class="card form">
            <div class="card-header">
                <h3><i class="fa fa-user-circle"></i> 权限列表</h3>
            </div>
            <br>

            <!--***** CONTENT *****-->
            <div class="row" style="margin: 0 20px;">
                <xblock>
                    <button class="btn btn-primary" onclick="x_admin_show('/web/privilege/create')">
                        添加
                    </button>
                    <span class="x-right">共有数据：{{$count}} 条</span>
                </xblock>

                <table class="table table-condensed">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>分类名</th>
                        <th>图标</th>
                        <th>链接</th>
                        <th>方法名称</th>
                        <th>排序</th>
                        <th>描述</th>
                        <th>操作</th>
                    </thead>
                    <tbody class="x-cate">
                    @if (count($result)>=1)
                        @foreach($result as $v)
                            @if ($v['pid'] == 0)
                                <tr cate-id="{{$v['id']}}" fid="0">
                                    <td>{{$v['id']}}</td>
                                    <td><i class="iconfont x-show" status='true'>&#xe79f;</i>{{$v['name']}}</td>
                                    <td><i class="{{$v['icon']}}" style="font-size:20px;"></i></td>
                                    <td>{{$v['link']}}</td>
                                    <td>{{$v['slug']}}</td>
                                    <td>{{$v['sort']}}</td>
                                    <td>{{$v['description']}}</td>
                                    <td class="td-manage">
                                        <a title="编辑" href="privilege/{{$v['id']}}/edit">
                                            <i class="iconfont">&#xe609;</i>
                                        </a>
                                        <a title="删除" onclick="member_del(this,'{{$v['id']}}')" href="javascript:;">
                                            <i class="iconfont">&#xe695;</i>
                                        </a>
                                    </td>

                                </tr>
                            @else
                                <tr cate-id="{{$v['id']}}" fid="{{$v['pid']}}">
                                    <td>{{$v['id']}}</td>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;├{{$v['name']}}</td>
                                    <td><i class="iconfont">{{$v['icon']}}</i></td>
                                    <td>{{$v['link']}}</td>
                                    <td>{{$v['slug']}}</td>
                                    <td>{{$v['sort']}}</td>
                                    <td>{{$v['description']}}</td>
                                    <td class="td-manage">
                                        <a title="编辑" href="privilege/{{$v['id']}}/edit">
                                            <i class="iconfont">&#xe609;</i>
                                        </a>
                                        <a title="删除" onclick="member_del(this,'{{$v['id']}}')" href="javascript:;">
                                            <i class="iconfont">&#xe695;</i>
                                        </a>
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                    @else
                        <tr>
                            <td colspan="6" style="text-align:center">暂无数据</td>
                        </tr>
                    @endif
                </table>

            </div>
        </div>


    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')

<!--Core Javascript -->
<link rel="stylesheet" href="{{ asset('xadmin/extra/jqueryConfirm/css/jquery-confirm.css')}}">
<script src="{{ asset('xadmin/extra/jqueryConfirm/js/jquery-confirm.min.js')}}"></script>

<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

<script type="text/javascript">
    function x_admin_show(url) {
        window.location.href = url;

        // window.open(url);
    }

    /*权限-删除*/
    function member_del(row, id) {


        $.confirm({
            // confirmButtonClass: 'btn-info',
            // cancelButtonClass: 'btn-info',
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            content:'确认要刪除吗？',
            confirmButton:'确认',
            cancelButton:'取消',


            confirm: function () {
                fetch_response('DELETE', "/web/privilege/" + id).then(function (res) {
                    $('body').toast({
                        position: 'fixed',
                        content: res.msg,
                        duration: 1000,
                        top: '50%'
                    });
                    setTimeout(function () {
                        window.location.href = '/web/privilege';
                    }, 2000)
                })

            },
            cancel: function () {
                $('body').toast({
                    position: 'fixed',
                    content: '已取消',
                    duration: 2000,
                    top: '50%'
                });
            }
        });
    }


    $("tbody.x-cate tr[fid!='0']").hide();

    var cateIds = [];

    function getCateId(cateId) {

        $("tbody tr[fid=" + cateId + "]").each(function (index, el) {
            id = $(el).attr('cate-id');
            cateIds.push(id);
            getCateId(id);
        });
    }

    // 栏目多级显示效果
    $('.x-show').click(function () {
        if ($(this).attr('status') == 'true') {
            $(this).html('&#xe66b;');
            $(this).attr('status', 'false');
            cateId = $(this).parents('tr').attr('cate-id');
            $("tbody tr[fid=" + cateId + "]").show();
        } else {
            cateIds = [];
            $(this).html('&#xe79f;');
            $(this).attr('status', 'true');
            cateId = $(this).parents('tr').attr('cate-id');
            getCateId(cateId);
            for (var i in cateIds) {
                $("tbody tr[cate-id=" + cateIds[i] + "]").hide().find('.x-show').html('&#xe79f;').attr('status', 'true');
            }
        }
    })

</script>

</body>

</html>