<!DOCTYPE html>
<html>

<head>

@include('admin.common_bak.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <link rel="stylesheet" href="{{ asset('xadmin/css/news/edit_news.css')}}">

    <script src="{{ asset('xadmin/js/news/edit_news.js')}}"></script>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i> 编辑新闻</h3>
                    </div>
                    <br>
                    <form id="form1">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title">新闻标题</label>
                                    <input type="text" class="form-control" name="title" value="{{$news->title}}" id="title" placeholder="新闻标题">
                                </div>
                                <div class="form-group">
                                    <label for="author">文章作者</label>
                                    <input type="text" class="form-control" name="author" id="author" value="@if($news->author!=''){{$news->author}}@else佚名@endif" name="link" placeholder="文章作者">
                                </div>

                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="origin">新闻来源</label>
                                    <input type="text" class="form-control" id="origin" name="origin" value="{{$news->origin}}" placeholder="新闻来源">
                                </div>

                                <div class="form-group has-success">
                                    <label for="web_url">新闻外链地址</label>
                                    <input type="text" class="form-control is-valid" name="web_url" id="web_url" value="{{$news->web_url}}" placeholder="新闻外链地址">
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label for="pid">栏目类别</label>
                                    <select class="form-control" name="category_id" id="pid">
                                        {{--<option value="0">请选择栏目</option>--}}
                                        @foreach($categories as $key => $category)
                                            @if(isset($category->childCag)&&!empty($category->childCag))
                                                <optgroup label="{{$category->title}}">
                                                    @foreach($category->childCag as $childCag)
                                                        <option value="{{$childCag['id']}}" <?php if($news->category_id==$childCag['id']) echo 'selected'?>>{{$childCag['title']}}</option>
                                                    @endforeach
                                                </optgroup>
                                            @else
                                                <option value="{{$category->id}}" <?php if($news->category_id==$category->id) echo 'selected'?>>{{$category->title}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label class="fileupload">多图新闻图片上传</label>
                                    <div class="layui-input-block">
                                        <input type="file" multiple id="fileupload" name="uploadfile" value=""/>
                                        <input type="hidden" id="fileuploadImg" name="images" value="{{$news->images}}"/>
                                        {{--<div class="layui-form-mid layui-word-aux">如果是多图新闻，请上传3张图片，每张500k以内；否则不用上传</div>--}}
                                    </div>
                                </div>

                            </div>

                            <div class="col-md-6">
                                <label class="layui-form-label">多图新闻图片预览</label>
                                <div class="layui-input-block">
                                    <ul id="img-list">
                                        @if(isset($news->imgs)&&!empty($news->imgs))
                                            @foreach($news->imgs as $img)
                                                <li><img src="{{ $img }}" alt="" class="mul-pic"><a onclick="delPic(this)"><span>删除</span></a></li>
                                            @endforeach
                                        @endif
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                    </ul>
                                </div>
                            </div>


                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_top">栏目内是否置顶</label>
                                    <input type="radio" id="show" name="is_top" @if($news->is_top=='y') checked @endif value="on">是
                                    <input type="radio" id="show" name="is_top"  @if($news->is_top=='n') checked @endif value="">否
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="is_hot">推荐到首页</label>
                                    <input type="radio" id="is_hot" name="is_hot" @if($news->is_hot=='y') checked @endif value="on">是
                                    <input type="radio" id="is_hot" name="is_hot"  @if($news->is_hot=='n') checked @endif value="">否
                                </div>
                            </div>

                            {{--<div class="col-md-12">--}}

                                {{--<div class="form-group">--}}
                                    {{--<label for="is_slide">是否为轮播</label>--}}
                                    {{--<input type="radio" id="show" name="is_slide" value="">是--}}
                                    {{--<input type="radio" id="show" name="is_slide" checked value="">否--}}

                                {{--</div>--}}
                            {{--</div>--}}

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="class_id">类别</label>
                                    <div class="input-group">
                                        {{--<input type="hidden" name="class_id" id="class_id">--}}

                                        @foreach($subclasses as $subclass)


                                            @if(isset($news->class_id)&&$news->class_id)
                                                <div class="checkbox">

                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" value="{{$subclass->id}}" @if(in_array($subclass->id,explode(',',$news->class_id))) checked @endif>
                                                        <span class="mr5" style="margin-right: 20px;">{{$subclass->title}}</span>
                                                    </label>
                                                </div>
                                            @else
                                                <div class="checkbox">
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" value="{{$subclass->id}}">
                                                        <span class="mr5" style="margin-right: 20px;">{{$subclass->title}}</span>
                                                    </label>
                                                </div>
                                            @endif
                                        @endforeach

                                    </div>
                                </div>

                            </div>

                            <div class="col-md-12">

                                <div class="form-group has-success">
                                    <label for="slug">标签</label>
                                    <input type="text" name="tags" class="form-control is-valid" value="{{$news->tags}}" placeholder="标签">
                                    <div class="layui-form-mid layui-word-aux">多标签新闻，标签之间请用“ , ”隔开。</div>
                                </div>

                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sort">排序（正序）</label>
                                    <input type="number" class="form-control" id="sort" name="sort" placeholder="排序" min="0" value="{{$news->sort}}">
                                </div>

                            </div>

                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="digest"><span class="x-red">*</span>摘要</label>
                                    <textarea class="form-control" name="digest" id="digest" rows="5" placeholder="摘要">{{$news->digest}}</textarea>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">描述</label>
                                    {{--<script id="editor" name="body" name="description" type="text/plain"></script>--}}
                                    <script id="editor" name="body" type="text/plain">
                                        <?php
                                        echo html_entity_decode($news->body, 1)
                                        ?>
                                    </script>
                                    {{--<input type="text" class="form-control" id="description" name="description" placeholder="描述">--}}
                                </div>
                            </div>


                            <div class="col-md-9" >
                                <div class="form-group">
                                    <label class="share_content"><span class="x-red">*</span>分享介绍</label>
                                    <textarea class="form-control" name="share_content" id="share_content" required rows="5"   placeholder="请输入分享简介" >{{$news->share_content}}</textarea>
                                </div>
                            </div>

                        </div>

                        <button type="submit" onclick="addPrivilege('{{$news->st}}','{{$news->st}}');" class="btn btn-general btn-blue mr-2">保存</button>
                        @if($news->st<40)
                        <button type="submit" onclick="addPrivilege(10,{{$news->st}});" class="btn btn-general btn-white">提交审核</button>
                        @endif
                        <button type="button" onclick="previewnews({{$news->id}});" class="btn btn-general btn-blue mr-2">预览</button>

                    </form>
                    <table class="table table-striped" style="margin-top: 20px;" >
                        <thead>
                        <tr>
                            <th>执行人</th>
                            {{--<th>下一步执行人</th>--}}
                            <th>执行时间</th>
                            {{--<th>结束时间</th>--}}
                            <th>执行结果</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($newsLogs as $log)
                            <tr>
                                <td>{{$log->user_name}}</td>
                                {{--<td>{{$log->next_user_name}}</td>--}}
                                <td>{{$log->created_at}}</td>
                                {{--<td>{{$log->end_datetime}}</td>--}}
                                <td>{{$log->title}}：{{$log->suggestions}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{asset('fileupload/js/vendor/jquery.ui.widget.js')}}"></script>
<script src="{{asset('fileupload/js/jquery.fileupload.js')}}"></script>

@include('admin.news.uditor')



<!--Core Javascript -->
<script type="text/javascript">

    var ue = UE.getEditor('editor',{
        initialFrameWidth : 800,
        initialFrameHeight: 400,
    });

    ue.ready(function(){
        //因为Laravel有防csrf防伪造攻击的处理所以加上此行
        ue.execCommand('serverparam','_token','{{ csrf_token() }}');
    });


    function addPrivilege(control,pre_st) {

        $("#form1").validate({
            rules: {
                title: {
                    required: true,
                    minlength: 2
                },
                password: {
                    link: true,
                    minlength: 5
                },
                author: {
                    required: true,
                },
                share_content: {
                    required: true,
                    // minlength:10,
                },
                origin:{
                    required:true,
                }
            },
            messages: {
                title: {
                    required: "标题不能为空",
                    minlength: "标题最小长度为2"
                },
                author: {
                    required: '作者不能为空'
                },
                share_content: {
                    required: "分享内容不能为空",
                    //minlength: "Your password must be at least 5 characters long"
                },
                origin:{
                    required:'新闻来源不能为空'
                }
            },
            submitHandler: function (form) {
                var form = document.querySelector("#form1");
                var formdata = new FormData(form);

                formdata.append('pre_st',pre_st)//原来新闻状态
                formdata.append('st',control);


                var class_ids = [];
                $('input:checkbox:checked').each(function(){
                    class_ids.push($(this).val())
                    $('#class_id').val(class_ids.join(','))
                })
                formdata.append('class_id',class_ids.join(','));

                fetch_response('PUT', '/web/news/{{$news->id}}?action=news_pass', formdata).then(function (res) {
                    if (res.code == 200) {
                        console.log('dsfsfsd',res)
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {

                            if (control==40) {
                                window.location.href = '/web/news_pass';
                            }else{
                                window.location.href = '/web/mynews';
                            }
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });


            },
            invalidHandler: function(form, validator) {
                console.log('fomr',form)
                return false;
            }

        });

    }
    function previewnews(id){
        var url = '{{config('custom.base_url')}}?id='+id;
        window.open(url)
    }

</script>
</body>
</html>