<!DOCTYPE html>
<html>

<head>

@include('admin.common.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <style>
        form.cmxform label.error, label.error {
            /* remove the next line when you have trouble in IE6 with labels in list */
            color: red;
            font-style: italic;
            margin-top: 11px;
        }
    </style>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i> 添加栏目</h3>
                    </div>
                    <br>
                    <form id="form1">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">栏目名称</label>
                                    <input type="text" class="form-control" name="name" id="name" placeholder="栏目名称">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">appID</label>
                                    <input type="text" class="form-control" name="media_category_id" value="" id="media_category_id" placeholder="Rbac平台appID">
                                </div>
                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_top">启用：</label>
                                    <input type="radio" id="status"  name="status" value="on">是
                                    <input type="radio" id="status" name="status" checked value="">否
                                </div>
                            </div>


                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">描述</label>
                                    <textarea name="description" class="form-control" id="" cols="30" rows="10"></textarea>
                                </div>
                            </div>

                        </div>

                        <button type="submit" onclick="addCategory();" class="btn btn-general btn-blue mr-2">提交</button>
                        <button type="reset" class="btn btn-general btn-white">取消</button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}


<!--Core Javascript -->
<script type="text/javascript">


    function addCategory() {

        $("#form1").validate({
            rules: {
                name: {
                    required: true,
                    minlength: 2
                },
                password: {
                    link: true,
                    minlength: 5
                },
                slug: {
                    required: true,
                },
                // email: {
                //     required: true,
                //     email: true
                // },
            },
            messages: {
                name: {
                    required: "Please enter a username",
                    minlength: "Your username must consist of at least 2 characters"
                },
                // password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long"
                // },
                // confirm_password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long",
                //     equalTo: "Please enter the same password as above"
                // },
                slug: "Please enter a valid slug",
            },
            submitHandler: function (form) {
                var form = document.querySelector("#form1");
                var formdata = new FormData(form);

                fetch_response('POST', '/web/media_category', formdata).then(function (res) {
                    if (res.code == 200) {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {
                            window.location.href = '/web/media_category';
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });


            },
            invalidHandler: function(form, validator) {
                console.log('fomr',form)
                return false;
            }

        });

    }

</script>
</body>

</html>