<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Jenssegers\Mongodb\Eloquent\Model as Eloquent;

class ModuleModel extends Eloquent
{
    public static function getModuleList($user,$category_id){

        if ($user['name'] == 'offcn' ){
            $module = file_get_contents(public_path('module.json'));
        }else{

            if ($user['media_show']){
                $module = file_get_contents(public_path('sub_admin.json'));
            }else{
                $module = file_get_contents(public_path('media_category.json'));
            }

            $tmp = json_decode($module,true);
            $result = [];
            /**
             * 控制大类显示
             */
            foreach ($tmp as $key => &$value){
                if ($value['show']  ){
                    /**
                     * 控制子类显示
                     */
                    $res = [];
                    foreach ($value['son'] as $item){
                        if ($item['have']){
                            $res[] = $item;
                        }
                    }
                    $value['son'] = $res;
                    $result[] = $value;
                }

            }

            if (Auth::user()){
                Auth::user()->permission = $result;
            }
            $module = json_encode($result);
        }

        return json_decode($module,true);
    }
}
