<?php

namespace App\Exports;

use App\Model\MediaModel;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithColumnWidths;

class MediasExport implements WithHeadings,FromArray,WithColumnWidths
{
    use Exportable;

    public function __construct($params)
    {
        $this->media_ids = $params;
    }

    public function columnWidths(): array
    {
        return [
            'A' => 30,
            'B' => 55,
            'C' => 45,
            'D' => 45,
            'E' => 55
        ];
    }

    /**
     * 设置表头
     * @return array
     */
    public function headings(): array
    {
        return [
            '媒资编号',
            "名称",
            '视频名称',
            "永久播放地址",
            "全屏预览地址",
        ];
    }

    public function array(): array
    {
        return $this->media_ids;
    }
}
