<!DOCTYPE html>
<html>

<head>

@include('admin.common.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <style>
        form.cmxform label.error, label.error {
            /* remove the next line when you have trouble in IE6 with labels in list */
            color: red;
            font-style: italic;
            margin-top: 11px;
        }
    </style>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <!--***** FORM GROUP *****-->
                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i>管理员注册</h3>
                    </div>


                    <br>
                    <form id="newForm">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <div class="form-group">
                            <label for="uesrname">用户名</label>
                            <div class="input-group ">
                                <div class="input-group-addon"><i class="fa fa-user-o"></i></div>
                                <input type="text" class="form-control" name="name" id="uesrname"
                                       placeholder="用户名">
                            </div>
                        </div>

                        {{--<div class="form-group">--}}
                            {{--<label for="nickname">昵称</label>--}}
                            {{--<div class="input-group ">--}}
                                {{--<div class="input-group-addon"><i class="fa fa-user-o"></i></div>--}}
                                {{--<input type="text" class="form-control" name="nickname" id="nickname"--}}
                                       {{--placeholder="昵称">--}}
                            {{--</div>--}}
                        {{--</div>--}}

                        <div class="form-group">
                            <label for="formGroupExampleInput2">密码<span class="red">*</span></label>
                            <div class="input-group ">
                                <div class="input-group-addon"><i class="fa fa-lock"></i></div>
                                <input type="password" class="form-control" value="" id="inlineFormInputGroup" placeholder="请输入密码">
                                <small class="form-text text-muted">6到16个字符</small>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="formGroupExampleInput2">确认密码</label>
                            <div class="input-group ">
                                <div class="input-group-addon"><i class="fa fa-lock"></i></div>
                                <input type="password" name="password" class="form-control" value="" id="inlineFormInputGroup" placeholder="请输入确认密码">
                            </div>
                        </div>

                        {{--<div class="form-group">--}}
                            {{--<label for="mobile">电话号码</label>--}}
                            {{--<div class="input-group ">--}}
                                {{--<div class="input-group-addon"><i class="fa fa-phone"></i></div>--}}
                                {{--<input type="text" class="form-control" name="mobile" id="mobile"--}}
                                       {{--placeholder="电话号码">--}}
                            {{--</div>--}}
                        {{--</div>--}}

                        {{--<div class="form-group">--}}
                            {{--<label for="mobile">邮箱</label>--}}
                            {{--<div class="input-group ">--}}
                                {{--<div class="input-group-addon"><i class="iconfont">&#xe610;</i></div>--}}
                                {{--<input type="text" class="form-control" name="email" id="emial"--}}
                                       {{--placeholder="邮箱">--}}
                            {{--</div>--}}
                        {{--</div>--}}

                        <div class="form-group">
                            <label for="role">角色</label>
                            <div class="input-group ">
                                {{--<div class="input-group-addon"><i class="fa fa-phone"></i></div>--}}
                                {{--<div class="checkbox">--}}
                                    {{--<label class="radio-inline">--}}
                                        {{--<input type="radio" name="inlineRadioOptions" id="inlineRadio1" value="option1" checked>--}}
                                        {{--<span class="mr5" style="margin-right: 20px;">普通用户</span>--}}
                                    {{--</label>--}}
                                {{--</div>--}}

                                <div class="checkbox">
                                    <label class="radio-inline">
                                        <input type="radio" name="inlineRadioOptions" id="inlineRadio1" value="option1" checked>
                                        <span class="mr5" style="margin-right: 20px;">管理员</span>
                                    </label>
                                </div>

                            </div>
                        </div>


                        <button type="submit" onclick="registerUser();"
                                class="btn btn-general btn-blue mr-2">确认
                        </button>
                        <button type="reset" class="btn btn-general btn-white">重置  </button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}


<!--Core Javascript -->
<script type="text/javascript">


    function registerUser() {

        $("#newForm").validate({
            rules: {
                // nickname: "required",
                uesrname: {
                    required: true,
                    minlength: 2
                },
                password: {
                    required: true,
                    minlength: 5
                },
                confirm_password: {
                    required: true,
                    minlength: 5,
                    equalTo: "#password"
                },
                email: {
                    required: true,
                    email: true
                },
            },
            messages: {
                // nickname: {
                //     required:''
                // },
                name: {
                    required: "昵称不能为空",
                    minlength: "昵称至少2个字符"
                },
                password: {
                    required: "请输入密码",
                    minlength: "密码长度不能小于5"
                },
                confirm_password: {
                    required: "请输入确认密码",
                    minlength: "密码长度不能小于5",
                    equalTo: "两次密码输入不一致"
                },
                email: "请输入有效邮箱",
            },
            submitHandler: function (form) {
                var form = document.querySelector("#newForm");
                var formdata = new FormData(form);

                fetch_response('POST', '/web/member', formdata).then(function (res) {
                    if (res.code == 200) {
                        //console.log('dsfsfsd')
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {
                            window.location.href = '/web/member';
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });
            }
        });

    }

</script>
</body>

</html>