<?php

namespace App\Providers;

use App\Model\ModuleModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
        $this->app->bind('logs',\App\Tool\Log::class);
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(Request $request)
    {
        view()->composer('*', $this->T($request->category_id));
    }
    private function T($c) {

        return function ($view) use ($c){

            $user = Auth::user();
            $result = ModuleModel::getModuleList($user,$c);

            $view->with([
                'left'       => $result,
            ]);
        };
    }
}
