<?php

namespace App\Model;

use App\Exceptions\DatabaseException;
use Jenssegers\Mongodb\Eloquent\Model as Eloquent;


class RecycleModel extends Eloquent
{
    /**
     * mongodb collection 名字
     */
    protected $collection = 'recycle';

    protected $connection = 'mongodb';  //使用mongodb

    protected $primaryKey = '_id';


    public static function addRecycle($obj_id,$obj_type="media"){
//        $recycle = RecycleModel::where([
//            "obj_type"  => $obj_type,
//            "obj_id"    => $obj_id,
//        ])->first();

//        if (!empty($recycle)){
//            throw new \Exception("回收站已存在");
//        }

        $obj_model = 'App\\Model\\'.ucfirst($obj_type).'Model';
        $model = new $obj_model();

        $obj = $model->find($obj_id);

        if (empty($obj)){
            throw new \Exception('数据不存在');
        }

        $data = [
            'obj_id'    => $obj_id,
            'obj_type'  => $obj_type,
            'content'   => json_encode($obj),
            'create_time'=> date('Y-m-d H:i:s',time())
        ];
        $id = RecycleModel::insertGetId($data);

        if (!$id){
            throw new \Exception('添加回收站失败');
        }

        return $id;
    }

}
