<?php

namespace App\Http\Controllers\Web;

use App\Model\MediaCategoryModel;
use App\Model\MediaModel;
use App\Tool\SrsHookValidate;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MediaController extends Controller
{
    /**
     * 媒资列表
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws \App\Exceptions\DatabaseException
     * @throws \App\Exceptions\FormException
     */
    public function index(Request $request){

        // php 特殊字符转义，实现字符串安全存入数据库，

        SrsHookValidate::srsHookCallback($request,[
            'media_name'    => '',
            'username'      => '',
            'page'          => 'integer',
            'media_id'      => '',
            'description'   => '',
            'sort'          => '',
            'page_size'     => 'integer',
            'start_time'    => 'date',
            'end_time'      => 'date',
            'category_id'   => '',
            'appid'         => ''
        ]);

        $medias = MediaModel::mediaList($request);

        return view('admin.media.media_list', [
            'medias'      => $medias,
            'start_time'  => substr($request->start_time, 0, 10),
            'end_time'    => substr($request->end_time, 0, 10),
            'media_name'  => $request->media_name,
            'media_id'    => $request->media_id,
            'STATUS'      => ['启用','停用'],
            'category_id' => $request->category_id,
            'appid'       => $request->appid,
            'page_size'   => $request->page_size,
            'username'    => $request->username,
        ]);

    }



    /**
     * 编辑房间
     * @param Request $request
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws \App\Exceptions\ControllerException
     */
    public function edit(Request $request,$id){

        $media = handler_drive(function () use ($request,$id){
            return MediaModel::getMediaDetail($id);
        });

        return view('admin.media.media_edit', [
            'media'         => $media,
        ]);

    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function update(Request $request,$id){

        $res = handler_drive(function () use ($request,$id){
            return MediaModel::updatehookMedia($request,$id);
        });
        return success($res);
    }

    /**
     * 显示
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws \App\Exceptions\ControllerException
     */
    public function create(Request $request){

        $reslut = handler_drive(function () use($request){
            $media_types = MediaCategoryModel::catgList($request);
            return $media_types;
        });

        $data['media_types'] = $reslut;
        $data['media_id'] = 'mda-'.generateRandomNum(16);
        return view('admin.media.media_add',$data);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function store(Request $request){

        $id = handler_drive(function () use($request){

            SrsHookValidate::srsHookCallback($request,[
                'media_name'  => 'required',
                'media_type'  => 'required',
                'media_id'    => 'required',
                'access_key'  => '',
                'secret_key'  => '',
                'media_url'   => 'required',
            ]);

            $data_time = Carbon::now();

            $params = array(
                'start_time'=> $data_time,
                'end_time'  => $data_time,
                'create_time'=> $data_time,
            );

            $request->replace(array_merge($request->all(),$params));


            return MediaModel::hookRestoreMedia($request);

        });

        return success($id);
    }

    /**
     * 删除媒资信息
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function destroy(Request $request,$id){

        $id = handler_drive(function () use($request,$id){

            return MediaModel::deleteMediaById($request,$id);

        });

        return success($id);

    }

    /**
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function media_command(){
        return view('admin.control');
    }

}
