<!DOCTYPE html>
<html>
@include('admin.common.commonMedia')

<link rel="stylesheet" href="{{asset('xadmin/extra/date/datepicker.css')}}">
<script src="{{ asset('xadmin/extra/date/datepicker.js')}}"></script>
<script src="{{ asset('xadmin/extra/date/datepicker.zh-CN.js')}}"></script>
<body>

<!--====================================================
                         MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                        PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner chart-cont">

        <div class="card form">
            <div class="card-header">
                <h3><i class="fa fa-user-circle"></i> 媒资列表</h3>
            </div>
            <br>

            <!--***** CONTENT *****-->
            <div class="row ml20">
                <div class="xblock">
                    @if(permissionExist("manager_media","media_create"))
                    <button class="btn btn-primary" onclick="x_admin_show('/web/media_model/create')">
                        添加
                    </button>
                    @endif
                    <form>
                        <input type="text" name="media_name" class="form-input" placeholder="请输入媒资名称" value="{{$media_name}}" autocomplete="off">
                        <input type="text" name="username" class="form-input" placeholder="请输入创建人" value="{{$username}}" autocomplete="off">
                        <input type="text" style="width: 200px;" name="media_id" class="form-input" placeholder="请输入媒资编号" value="{{$media_id}}" autocomplete="off">
                        <input class="form-input" name="start_time" data-toggle="start_time" autocomplete="off" value="{{$start_time}}" placeholder="请输入开始时间"/>
                        <input class="form-input" name="end_time" data-toggle="end_time" autocomplete="off" value="{{$end_time}}" placeholder="请输入结束时间"/>
                        <input type="hidden" name="category_id" value="{{$category_id}}">
                        <input type="hidden" name="appid" value="{{$appid}}">
                        <button type="submit" class="btn btn-primary">搜索</button>
                    </form>
                    <span  style="display: inline-block;height: 40px;line-height: 40px; float: right">共{{$medias->total()}}条</span>
                </div>

                <table class="table table-hover">
                    <thead>
                    <tr class="bg-info text-white">
                        <th>序号</th>
                        <th>媒资编号</th>
                        <th>媒资名称</th>
                        <th>视频类别</th>
                        <th>视频地址</th>
                        <th>创建时间</th>
                        <th>媒资号码</th>
                        <th>时长（s）</th>
                        <th>操作</th>
                    </tr>
                    </thead>
                    <tbody>

                    @if(count($medias)>0)
                        @foreach ($medias as $key => $media)
                            <tr class="<?php if($key%2==0) echo 'table-success';?>">
                                <td>{{$key+1}}</td>
                                <td style="max-width: 120px;">{{$media['_id']}}</td>
                                <td style="max-width: 150px;">{{$media['media_name']}}</td>
                                <td style="max-width: 50px;">{{$media['media_type']}}</td>
                                <td style="max-width: 200px;">{{$media['media_url']}}</td>
                                <td style="max-width: 100px;">{{$media['create_time']}}</td>

                                @if(isset($media['media_num']))
                                    <td style="max-width: 100px;">{{$media['media_num']}}</td>
                                @else
                                    <td></td>
                                @endif

                                @if(isset($media['duration']))
                                    <td style="max-width: 100px;">{{$media['duration']}}</td>
                                @else
                                    <td></td>
                                @endif
                                <td class="td-manage">
                                    @if(permissionExist("manager_media","media_edit"))

                                    <a title="编辑" href="/web/media_model/{{$media['_id']}}/edit">
                                        <i class="iconfont">&#xe609;</i>
                                    </a>
                                    @endif
                                    {{--<a onclick="x_admin_show('修改密码','/web/password/{{$user->id}}',500,300)" title="修改密码"--}}
                                    {{--href="javascript:;">--}}
                                    {{--<i class="iconfont">&#xe61a;</i>--}}
                                    {{--</a>--}}

                                    @if(permissionExist("manager_media","media_model_destroy"))
                                        <a title="删除" onclick="member_del(this,'{{$media["_id"]}}')" href="javascript:;">
                                            <i class="iconfont">&#xe695;</i>
                                        </a>
                                    @endif

                                    @if(isset($media["media_num"]))
                                        <a title="视频预览" href="javascript:;" onclick="preview_video(this,'{{$media["media_num"]}}')">
                                            <i class="iconfont">&#xe79f;</i>
                                        </a>

                                        <a title="全屏预览" href="javascript:;" onclick="preview_video(this,'{{$media["media_num"]}}',1)">
                                            <i class="iconfont">&#xe627;</i>
                                        </a>
                                    @else
                                        <a title="生成媒资号码" onclick="set_media_num(this,'{{$media["_id"]}}')" href="javascript:;">
                                            <i class="iconfont">&#xe61a;</i>
                                        </a>
                                    @endif

                                    <a title="清除cdn缓存" onclick="clear_cdn_cache(this,'{{$media["_id"]}}')" href="javascript:;">
                                        <i class="iconfont">&#xe615;</i>
                                    </a>

                                    <a title="获取永久播放地址" id="{{$media["_id"]}}" data-toggle="modal" data-target=".bd-example-modal-lg" onclick="get_farvor_m3u8(this,'{{$media["_id"]}}')" href="javascript:;">
                                        <i class="iconfont">&#xe668;</i>
                                    </a>

                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="9" style="text-align:center">暂无数据</td>
                        </tr>
                    @endif
                    </tbody>
                </table>

                <div class="page">
                    <div>
                        {{$medias->appends(['media_name'=>$media_name,'username' => $username,'start_time'=>$start_time,'end_time'=>$end_time,'media_id'=>$media_id,'category_id'=>$category_id,'appid' => $appid ,'page_size' => $page_size])->links()}}
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')

<!--Core Javascript -->
<link rel="stylesheet" href="{{ asset('xadmin/extra/jqueryConfirm/css/jquery-confirm.css')}}">
<script src="{{ asset('xadmin/extra/jqueryConfirm/js/jquery-confirm.min.js')}}"></script>

<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>
<script type="text/javascript" src="http://www.jq22.com/demo/clipboard.js-master201703170013/dist/clipboard.min.js"></script>

<script type="text/javascript">

    function x_admin_show(url){
        window.location.href = url;
    }


    function member_del(row,id){

        $.confirm({
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            content:'确认要刪除吗？',
            confirmButton:'确认',
            cancelButton:'取消',

            confirm: function () {
                fetch_response('DELETE',"/web/media_model/"+id).then(function (res) {
                    if (res.code==200) {
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                        setTimeout(function () {
                            window.location.href='/web/media_model?media_name={{$media_name}}&media_id={{$media_id}}&start_time={{$start_time}}&end_time={{$end_time}}&category_id={{$category_id}}&appid={{$appid}}';
                        },2000)
                    }else{
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                    }
                })
            },
            cancel: function () {
                $('body').toast({
                    position:'fixed',
                    content:'已取消',
                    duration:1000,
                    top:'50%'
                });
            }
        });
    }

    /**
     * 设置媒资随机码
     * @param row
     * @param id
     */
    function set_media_num(row,id){

        $.confirm({
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            content:'确认要设置媒资编号吗？',
            confirmButton:'确认',
            cancelButton:'取消',

            confirm: function () {
                var formData = new FormData();
                formData.append('media_id',id);

                fetch_response('post',"/web/set_media_num",formData).then(function (res) {
                    if (res.code==200) {
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                        setTimeout(function () {
                            window.location.href='/web/media_model?media_name={{$media_name}}&media_id={{$media_id}}&start_time={{$start_time}}&end_time={{$end_time}}&category_id={{$category_id}}&appid={{$appid}}&page={{$page}}';
                        },2000)
                    }else{
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                    }
                })
            },
            cancel: function () {
                $('body').toast({
                    position:'fixed',
                    content:'已取消',
                    duration:1000,
                    top:'50%'
                });
            }
        });
    }

    /**
     * 清除CDN缓存
     * @param row
     * @param id
     */
    function clear_cdn_cache(row,id){

        $.confirm({
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            content:'确认要强制更新CND缓存吗？',
            confirmButton:'确认',
            cancelButton:'取消',

            confirm: function () {
                fetch_response('GET',"/web/clear_cdn_cache/"+id).then(function (res) {
                    if (res.code==200) {
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                        setTimeout(function () {
                            window.location.href='/web/media_model?media_name={{$media_name}}&media_id={{$media_id}}&start_time={{$start_time}}&end_time={{$end_time}}&category_id={{$category_id}}&appid={{$appid}}&page={{$page}}';
                        },2000)
                    }else{
                        $('body').toast({
                            position:'fixed',
                            content:res.msg,
                            duration:1000,
                            top:'50%'
                        });
                    }
                })
            },
            cancel: function () {
                $('body').toast({
                    position:'fixed',
                    content:'已取消',
                    duration:1000,
                    top:'50%'
                });
            }
        });
    }

    /**
     * 视频预览
     * @param row
     * @param id
     */
    function preview_video(row,id,fullScreen){
        var href = "/web/video_preview/"+id;
        if (fullScreen !== undefined){
            href = "/web/video_preview/"+id+"?fullScreen="+fullScreen;
        }
        window.open(href);
    }

    // updateConfig(1);

    $('#endDate').bind("onclickOnce",function () {
        alert('sdfs')
    })

    function updateConfig(num) {


        $('#endDate').daterangepicker({
            "startDate": "06/26/2020",
            "endDate": "07/02/2020"
        }, function(start, end, label) {
            console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
        });

        // var options = {};
        //
        // options.locale = {
        //     // direction: $('#rtl').is(':checked') ? 'rtl' : 'ltr',
        //     // format: 'MM/DD/YYYY HH:mm',
        //
        //     startDate:"",
        //     endDate:"",
        //     format: 'YYYY/MM/DD',
        //     separator: ' - ',
        //     applyLabel: '确定',
        //     cancelLabel: '取消',
        //     fromLabel: 'From',
        //     toLabel: 'To',
        //     customRangeLabel: 'Custom',
        //     daysOfWeek: ['日', '一', '二', '三', '四', '五','六'],
        //     monthNames: ['一月', '二月', '三月', '四月', '五月', '六月', '七月', '八月', '九月', '十月', '十一月', '十二月'],
        //     firstDay: 1,
        //     autoApply:true,
        // };
        //
        // $('#endDate').daterangepicker(options, function(start, end) {
        //
        //
        //     console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') );
        //
        //
        // });

    }

    $(function () {
        $('[data-toggle="start_time"]').datepicker({
            format: 'yyyy-mm-dd',
            language: 'zh-CN',
        });

        $('[data-toggle="end_time"]').datepicker({
            format: 'yyyy-mm-dd',
            language: 'zh-CN',
        });
    })

    function get_farvor_m3u8(row,media_id) {

        $.ajax({
            url:"/api/user/get_fervor_m3u8?media_id="+media_id,
            dataType:"json",
            success:function (res) {
                var url = res.data.url;
                $('.modal-content').html(url)

            }
        })

    }



</script>

<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content"></div>
    </div>
</div>
<style>
    .model{
        z-index: 9999;
    }
    .modal-content{
        word-break: break-word;
        top: 100px;
        padding: 20px;
    }
</style>

</body>

</html>