var img_list = [];

/*jslint unparam: true */
/*global window, $ */
$(function () {
    'use strict';
    // Change this to the location of your server-side upload handler:

    $('#fileupload').fileupload({
        url: '/web/picupload?dirname=product',
        dataType: 'json',
        add: function (e, data) {

            var uploadErrors = [];
            var acceptFileTypes = /^image\/(gif|jpe?g|png)$/i;

            //console.log('data',data)

            //文件类型判断
            if(data.originalFiles[0].type.length && !acceptFileTypes.test(data.originalFiles[0].type)) {
                uploadErrors.push('请上传gif、jpg、jpeg或png格式的文件');
            }

            //文件大小判断
            if(data.originalFiles[0].size > (2*1024*1024)) {
                uploadErrors.push('请上传不超过2M的文件');
            }

            if(uploadErrors.length > 0) {

                $('body').toast({
                    position: 'fixed',
                    content: uploadErrors.join("\n"),
                    duration: 2000,
                    top: '50%'
                });
            } else {
                data.submit();
            }
        },
        done: function (e, data) {
            var file_img = data.result.data.file_path;

            var my_test = [];

            // $('<li><img src="'+file_img+'"></li>').appendTo('#img-list');
            $('<li><img src="' + file_img + '" class="mul-pic"><a onclick="delPic(this)"><span>删除</span></a></li>').appendTo('#img-list');

            $('#img-list img').each(function(){
                my_test.push($(this).attr('src'))
            })

            $('#fileuploadImg').attr("value", my_test);

            if (my_test.length) {
                $('#img-list').parent().parent().removeClass('hide');
                $('#img-list').parent().parent().addClass('show');
            }

            //console.log('img_list',img_list);
        },
        progressall: function (e, data) {
            var progress = parseInt(data.loaded / data.total * 100, 10);
            $('#progress .progress-bar').css(
                'width',
                progress + '%'
            );
        }
    }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');
});

function picViewer(id, show, delid) {
    var r = new FileReader();
    var imgurl = document.getElementById(id).files[0];


    r.readAsDataURL(imgurl);
    r.onload = function (e) {
        document.getElementById(show).src = this.result;
        document.getElementById(delid).style.visibility = 'visible';
    };
}

function delLocalPic(id, show, delid) {
    document.getElementById(id).value = '';
    document.getElementById(show).src = '';
    document.getElementById(delid).style.visibility = 'hidden';
}

function delPic(pic) {

    $(pic).parent().remove();

    var imglist = $("#img-list img");
    var img_list = [];


    for (var i = 0; i < imglist.length; i++) {
        if (imglist[i].getAttribute('src')) {
            img_list.push(imglist[i].getAttribute('src'));
        }
    }
    // console.log('=========',img_list)
    $('#fileuploadImg').attr("value", img_list.join(','));

    if (img_list.length == 0) {
        $('#img-list').parent().parent().removeClass('show');
        $('#img-list').parent().parent().addClass('hide');
    }

    // console.log("$('#fileuploadImg')",$('#fileuploadImg').val())
}

