<?php

namespace App\Model;

use App\Tool\Log;
use Jenssegers\Mongodb\Eloquent\Model as Eloquent;

class LogModel extends Eloquent
{

    /**
     * 与模型关联的数据表
     * @var string
     */
    protected $table = 'log';
    # 是否自动维护时间戳
    public $timestamps = false;


    /**
     * 添加一个日志
     * @param  $content
     * @param int $type 1 一般  2 警告 3 错误
     * @param string $uid 账户标示
     */
    public static function addlog($content, int $type = 1, string $uid = '', $code = '')
    {
        $uri = $_SERVER['REQUEST_URI'] ?? 'cli';

        //写入数据库
        $data = ['msg' => $content, 'type' => $type, 'uri' => $uri];
//        self::add($data);

        //写入文件
        $jsonData = json_encode($data, JSON_UNESCAPED_UNICODE);
        //根据类型不同，生成不同日志
        if ($type == 1) {
            app()->make('logs')::info($uid, $code, $jsonData);
        } elseif ($type == 2) {
            app()->make('logs')::warn($uid, $code, $jsonData);
        } elseif ($type == 3) {
            app()->make('logs')::fatal($uid, $code, $jsonData);
        }
    }
}