<?php

namespace App\Http\Controllers\Api\Client;

use App\Exceptions\ControllerException;
use App\Exceptions\DatabaseException;
use App\Model\LogModel;
use App\Model\MediaCategoryModel;
use App\Model\MediaModel;
use App\Model\UserModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use MongoDB\BSON\UTCDateTime;

class UsersController extends Controller
{

    /**
     * 第三方验权
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws ControllerException
     */
    public function store(Request $request){


        $response = handler_drive(function () use ($request) {

            if (!$request->password) {
                throw new ControllerException('口令不能为空',400);
            }
            if ($request->filled('username')) {
                if (mb_strlen($request->username)>=20) {
                    $request->username = mb_substr($request->username,0,20,"UTF-8").'...';
                }
            } else {
                throw new ControllerException('昵称必须填写',400);
            }


            if (preg_match("['|\"|\/|\\\|\.|:]", $request->uuid)) {
                throw new ControllerException('uuid含有非法字符',400);
            }

            return UserModel::checkUserRole($request);

        });

        return success($response);

    }

}
