<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithHeadings;

use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;


class MubanExport implements WithColumnWidths,WithHeadings,FromArray,WithStyles
{
    use Exportable;

    public function headings(): array
    {
        return [
            '名称',
            '媒资编号',
        ];
    }

    /**
     * 设置表头
     * @return array
     */
    public function columnWidths(): array
    {
        return [
            'A' => 55,
            'B' => 45,
        ];
    }

    public function array(): array
    {
        return [
            ["【第一章马克思主义哲学是科学的世界观和方法论第一节哲学及其基本问题】.mp4", "mda-250f994a93f2688ba225532c641b2a34"],
            ["【19课堂】2021.03.02-月半时政-脱贫攻坚-公基-李浩祥】.mp4", "mda-a4c0ad458d3592ff798277a42cb57be6"],
            ["视频名称是必填项","媒资编号为必填项"]
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            'A4'    => ['font' => ['bold' => true]],
            'B4'  => ['font' => ['bold' => true]],
        ];
    }

}
