<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


Route::group(['namespace' => 'Api', 'prefix' => 'v1', 'middleware' => ['auth']], function () {

    # 用户模块
    Route::post('users', 'Client\UsersController@store');

    Route::get('media_catg', 'Client\MediaCategoryController@index');
    Route::get('generate_media_id', 'Client\MediaController@index');
    Route::get('upload_token', 'Client\MediaController@getUploadMediaToken');
    Route::post('hook_restore', 'Client\MediaController@hookRestoreMedia');
    Route::post('update_media/{id}', 'Client\MediaController@updatehookMedia');


});





Route::group(['namespace' => 'Api', 'prefix' => 'user'], function () {
    Route::post("media_list","MediaController@media_list");
});