<!DOCTYPE html>
<html>

@include('admin.common_bak.commonMedia')

<body>

<!--====================================================
                         MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                        PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner chart-cont">

        <div class="card form">
            <div class="card-header">
                <h3><i class="fa fa-user-circle"></i> 栏目列表</h3>
            </div>
            <br>

            <!--***** CONTENT *****-->
            <div class="row" style="margin: 0 20px;">
                <xblock>
                    <button class="btn btn-primary" onclick="x_admin_show('/web/news_category/create')">
                        添加
                    </button>
                    <span class="x-right">共有数据：{{$count}} 条</span>
                </xblock>

                <table class="table table-condensed">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>分类名</th>
                        <th>排序</th>
                        <th>状态</th>
                        {{--<th>链接</th>--}}
                        {{--<th>方法名称</th>--}}
                        <th>描述</th>
                        <th>操作</th>
                    </thead>
                    <tbody class="x-cate">
                    @if (count($result)>=1)
                        @foreach($result as $v)
                            @if ($v['parent_id'] == 0)

                                @if(isset($v['son']))

                                    <tr cate-id="{{$v['id']}}" fid="0">
                                        <td>{{$v['id']}}</td>
                                        <td><i class="iconfont x-show" status='true'>&#xe79f;</i>{{$v['title']}}</td>
                                        <td>{{$v['sort']}}</td>
                                        @if($v['st']== 0)
                                            <td>启用</td>
                                        @else
                                            <td>禁用</td>
                                        @endif
                                        {{--<td>{{$v['slug']}}</td>--}}
                                        <td>{{$v['description']}}</td>
                                        <td class="td-manage">
                                            <a title="编辑" href="news_category/{{$v['id']}}/edit">
                                                <i class="iconfont">&#xe609;</i>
                                            </a>
                                            <a title="删除" onclick="member_del(this,'{{$v['id']}}')" href="javascript:;">
                                                <i class="iconfont">&#xe695;</i>
                                            </a>
                                        </td>

                                    </tr>

                                    @foreach($v['son'] as $son)

                                        @if(isset($son['son']))
                                            <tr cate-id="{{$son['id']}}" fid="{{$v['id']}}">
                                                <td>{{$son['id']}}</td>
                                                <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;├<i class="iconfont x-show" status='true'>&#xe79f;</i>{{$son['title']}}</td>
                                                <td>{{$son['sort']}}</td>
                                                @if($son['st']== 0)
                                                    <td>启用</td>
                                                @else
                                                    <td>禁用</td>
                                                @endif
                                                {{--<td>{{$v['slug']}}</td>--}}
                                                <td>{{$son['description']}}</td>
                                                <td class="td-manage">
                                                    <a title="编辑" href="news_category/{{$son['id']}}/edit">
                                                        <i class="iconfont">&#xe609;</i>
                                                    </a>
                                                    <a title="删除" onclick="member_del(this,'{{$son['id']}}')"
                                                       href="javascript:;">
                                                        <i class="iconfont">&#xe695;</i>
                                                    </a>
                                                </td>

                                            </tr>

                                            @foreach($son['son'] as $last_son)

                                                <tr cate-id="{{$last_son['id']}}" fid="{{$son['id']}}">
                                                    <td>{{$last_son['id']}}</td>
                                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;├{{$last_son['title']}}</td>
                                                    <td>{{$last_son['sort']}}</td>
                                                    @if($last_son['st']== 0)
                                                        <td>启用</td>
                                                    @else
                                                        <td>禁用</td>
                                                    @endif
                                                    {{--<td>{{$v['slug']}}</td>--}}
                                                    <td>{{$last_son['description']}}</td>
                                                    <td class="td-manage">
                                                        <a title="编辑" href="news_category/{{$last_son['id']}}/edit">
                                                            <i class="iconfont">&#xe609;</i>
                                                        </a>
                                                        <a title="删除" onclick="member_del(this,'{{$last_son['id']}}')"
                                                           href="javascript:;">
                                                            <i class="iconfont">&#xe695;</i>
                                                        </a>
                                                    </td>

                                                </tr>

                                            @endforeach


                                        @else


                                            <tr cate-id="{{$son['id']}}" fid="{{$v['id']}}">
                                                <td>{{$son['id']}}</td>
                                                <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;├<i
                                                            class="iconfont x-show"
                                                            status='true'>&#xe79f;</i>{{$son['title']}}</td>
                                                <td>{{$son['sort']}}</td>
                                                @if($son['st']== 0)
                                                    <td>启用</td>
                                                @else
                                                    <td>禁用</td>
                                                @endif
                                                {{--<td>{{$v['slug']}}</td>--}}
                                                <td>{{$son['description']}}</td>
                                                <td class="td-manage">
                                                    <a title="编辑" href="news_category/{{$son['id']}}/edit">
                                                        <i class="iconfont">&#xe609;</i>
                                                    </a>
                                                    <a title="删除" onclick="member_del(this,'{{$son['id']}}')"
                                                       href="javascript:;">
                                                        <i class="iconfont">&#xe695;</i>
                                                    </a>
                                                </td>

                                            </tr>

                                        @endif



                                    @endforeach


                                @else

                                    <tr cate-id="{{$v['id']}}" fid="0">
                                        <td>{{$v['id']}}</td>
                                        <td><i class="iconfont x-show" status='true'>&#xe79f;</i>{{$v['title']}}</td>
                                        <td>{{$v['sort']}}</td>
                                        @if($v['st']== 0)
                                            <td>启用</td>
                                        @else
                                            <td>禁用</td>
                                        @endif
                                        {{--<td>{{$v['slug']}}</td>--}}
                                        <td>{{$v['description']}}</td>
                                        <td class="td-manage">
                                            <a title="编辑" href="news_category/{{$v['id']}}/edit">
                                                <i class="iconfont">&#xe609;</i>
                                            </a>
                                            <a title="删除" onclick="member_del(this,'{{$v['id']}}')" href="javascript:;">
                                                <i class="iconfont">&#xe695;</i>
                                            </a>
                                        </td>

                                    </tr>



                                @endif


                            @else
                                <tr cate-id="{{$v['id']}}" fid="{{$v['parent_id']}}">
                                    <td>{{$v['id']}}</td>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;├{{$v['title']}}</td>
                                    <td>{{$v['sort']}}</td>
                                    @if($v['st']== 0)
                                        <td>启用</td>
                                    @else
                                        <td>禁用</td>
                                    @endif
                                    {{--<td>{{$v['link']}}</td>--}}
                                    {{--<td>{{$v['slug']}}</td>--}}
                                    <td>{{$v['description']}}</td>
                                    <td class="td-manage">
                                        <a title="编辑"
                                           onclick="x_admin_show('编辑','news_category/{{$v['id']}}/edit',440,500)"
                                           href="javascript:;">
                                            <i class="iconfont">&#xe609;</i>
                                        </a>
                                        <a title="删除" onclick="member_del(this,'{{$v['id']}}')" href="javascript:;">
                                            <i class="iconfont">&#xe695;</i>
                                        </a>
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                    @else
                        <tr>
                            <td colspan="6" style="text-align:center">暂无数据</td>
                        </tr>
                    @endif
                </table>

            </div>
        </div>


    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')

<!--Core Javascript -->
<link rel="stylesheet" href="{{ asset('xadmin/extra/jqueryConfirm/css/jquery-confirm.css')}}">
<script src="{{ asset('xadmin/extra/jqueryConfirm/js/jquery-confirm.min.js')}}"></script>

<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

<script type="text/javascript">
    function x_admin_show(url) {
        window.location.href = url;

        // window.open(url);
    }

    /*权限-删除*/
    function member_del(row, id) {


        $.confirm({
            // confirmButtonClass: 'btn-info',
            // cancelButtonClass: 'btn-info',
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            confirmButton: '确认',
            cancelButton: '取消',
            content:'确认要删除吗？',


            confirm: function () {
                fetch_response('DELETE', "/web/news_category/" + id).then(function (res) {
                    $('body').toast({
                        position: 'fixed',
                        content: res.msg,
                        duration: 1000,
                        top: '50%'
                    });

                    if (res.code == 200) {

                        setTimeout(function () {
                            window.location.href = '/web/news_category';
                        }, 2000)
                    }
                }).error(function (err) {
                    console.log('err')
                })

            },
            cancel: function () {
                $.alert('cancel triggered!');
            }
        });
    }


    $("tbody.x-cate tr[fid!='0']").hide();

    var cateIds = [];

    function getCateId(cateId) {

        $("tbody tr[fid=" + cateId + "]").each(function (index, el) {
            id = $(el).attr('cate-id');
            cateIds.push(id);
            getCateId(id);
        });
    }

    // 栏目多级显示效果
    $('.x-show').click(function () {
        if ($(this).attr('status') == 'true') {
            $(this).html('&#xe66b;');
            $(this).attr('status', 'false');
            cateId = $(this).parents('tr').attr('cate-id');
            $("tbody tr[fid=" + cateId + "]").show();
        } else {
            cateIds = [];
            $(this).html('&#xe79f;');
            $(this).attr('status', 'true');
            cateId = $(this).parents('tr').attr('cate-id');
            getCateId(cateId);
            for (var i in cateIds) {
                $("tbody tr[cate-id=" + cateIds[i] + "]").hide().find('.x-show').html('&#xe623;').attr('status', 'true');
            }
        }
    })

</script>

</body>

</html>