<!DOCTYPE html>
<html>

<head>

@include('admin.common_bak.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <style>
        form.cmxform label.error, label.error {
            /* remove the next line when you have trouble in IE6 with labels in list */
            color: red;
            font-style: italic;
            margin-top: 11px;
        }
    </style>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i> 添加栏目</h3>
                    </div>
                    <br>
                    <form id="form1">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">栏目名称</label>
                                    <input type="text" class="form-control" name="title" id="name" placeholder="栏目名称">
                                </div>


                            </div>
                            {{--<div class="col-md-6">--}}
                                {{--<div class="form-group">--}}
                                    {{--<label for="icon">图标</label>--}}
                                    {{--<input type="text" class="form-control" id="icon" name="icon" placeholder="图标">--}}
                                {{--</div>--}}

                                {{--<div class="form-group has-success">--}}
                                    {{--<label for="slug">方法名称</label>--}}
                                    {{--<input type="text" class="form-control is-valid" name="slug" id="slug" placeholder="控制器.方法名">--}}
                                {{--</div>--}}
                            {{--</div>--}}

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label for="pid">父类</label>
                                    {{--<select class="form-control" name="parent_id" id="pid">--}}
                                        {{--<option value="0">请选择父类</option>--}}
                                        {{--@if (count($result) > 0)--}}
                                            {{--@foreach($result as $v)--}}
                                                {{--<option value="{{$v['id']}}" @if($result[0]['parent_id'] == $v['id']) selected @endif>{{$v['title']}}</option>--}}
                                            {{--@endforeach--}}
                                        {{--@endif--}}
                                    {{--</select>--}}


                                    <select class="form-control" name="parent_id" id="pid">
                                        <option value="0">请选择栏目</option>
                                        @foreach($categories as $key => $category)
                                            @if(isset($category->childCag)&&!empty($category->childCag))
                                                <option value="{{$category->id}}" style="font-size: 18px;font-weight:bold;">{{$category->title}}</option>
                                                <optgroup label="&nbsp;├">
                                                    @foreach($category->childCag as $childCag)
                                                        <option value="{{$childCag['id']}}">{{$childCag['title']}}</option>
                                                    @endforeach
                                                </optgroup>
                                            @else
                                                <option value="{{$category->id}}">{{$category->title}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            {{--<div class="col-md-12">--}}

                                {{--<div class="form-group">--}}
                                    {{--<label for="show">是否显示</label>--}}
                                    {{--<input type="radio" id="show" name="show" value="">是--}}
                                    {{--<input type="radio" id="show" name="show" checked value="">否--}}
                                {{--</div>--}}
                            {{--</div>--}}

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_dynamic">是否为动态</label>
                                    <input type="radio" id="is_dynamic" name="is_dynamic" value="">是
                                    <input type="radio" id="is_dynamic" name="is_dynamic" checked value="">否
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sort">排序（正序）</label>
                                    <input type="number" class="form-control" id="sort" name="sort" placeholder="排序" min="0" value="0">
                                </div>

                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">描述</label>
                                    <input type="text" class="form-control" id="description" name="description" placeholder="描述">
                                </div>
                            </div>

                        </div>

                        <button type="submit" onclick="addPrivilege();" class="btn btn-general btn-blue mr-2">Submit</button>
                        <button type="reset" class="btn btn-general btn-white">Cancel</button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}


<!--Core Javascript -->
<script type="text/javascript">


    function addPrivilege() {

        $("#form1").validate({
            rules: {
                name: {
                    required: true,
                    minlength: 2
                },
                password: {
                    link: true,
                    minlength: 5
                },
                slug: {
                    required: true,
                },
                // email: {
                //     required: true,
                //     email: true
                // },
            },
            messages: {
                name: {
                    required: "Please enter a username",
                    minlength: "Your username must consist of at least 2 characters"
                },
                // password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long"
                // },
                // confirm_password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long",
                //     equalTo: "Please enter the same password as above"
                // },
                slug: "Please enter a valid slug",
            },
            submitHandler: function (form) {
                var form = document.querySelector("#form1");
                var formdata = new FormData(form);

                fetch_response('POST', '/web/news_category', formdata).then(function (res) {
                    if (res.code == 200) {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {
                            window.location.href = '/web/news_category';
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });


            },
            invalidHandler: function(form, validator) {
                console.log('fomr',form)
                return false;
            }

        });

    }

</script>
</body>

</html>