<!DOCTYPE html>
<html>

<head>

@include('admin.common_bak.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <link rel="stylesheet" href="{{ asset('xadmin/css/news/edit_news.css')}}">

    <script src="{{ asset('xadmin/js/news/edit_news.js')}}"></script>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i> 添加新闻</h3>
                    </div>
                    <br>
                    <form id="form1">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title">新闻标题</label>
                                    <input type="text" class="form-control" name="title" id="title" placeholder="新闻标题">
                                </div>
                                <div class="form-group">
                                    <label for="author">文章作者</label>
                                    <input type="text" class="form-control" id="author" name="author" placeholder="文章作者"
                                           value="佚名">
                                </div>

                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="origin">新闻来源</label>
                                    <input type="text" class="form-control" id="origin" name="origin"
                                           placeholder="新闻来源">
                                </div>

                                <div class="form-group has-success">
                                    <label for="web_url">新闻外链地址</label>
                                    <input type="text" class="form-control is-valid" name="web_url" id="web_url"
                                           placeholder="新闻外链地址">
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label for="pid">栏目类别</label>
                                    <select class="form-control" name="category_id" id="pid">
                                        <option value="0">请选择栏目</option>
                                        @foreach($categories as $key => $category)
                                            @if(isset($category->childCag)&&!empty($category->childCag))
                                                <optgroup label="{{$category->title}}">
                                                    @foreach($category->childCag as $childCag)
                                                        <option value="{{$childCag['id']}}">{{$childCag['title']}}</option>
                                                    @endforeach
                                                </optgroup>
                                            @else
                                                <option value="{{$category->id}}">{{$category->title}}</option>
                                            @endif
                                        @endforeach
                                    </select>

                                </div>

                            </div>

                            <div class="col-md-6">

                                <div class="form-group has-success">
                                    <label for="slug">上级</label>
                                    <input type="hidden" name="superior_ids" class="form-control is-valid"
                                           value="{{$user_id}}" readonly="">

                                    <input type="text" class="form-control is-valid" value="{{$username}}" readonly="">
                                </div>

                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label class="fileupload">多图新闻图片上传</label>
                                    <div class="layui-input-block">
                                        <input type="file" multiple id="fileupload" name="uploadfile" value=""/>
                                        <input type="hidden" id="fileuploadImg" name="images" value=""/>
                                        {{--<div class="layui-form-mid layui-word-aux">如果是多图新闻，请上传3张图片，每张500k以内；否则不用上传</div>--}}
                                    </div>
                                </div>

                            </div>

                            <div class="col-md-6 hide">
                                <label class="layui-form-label">多图新闻图片预览</label>
                                <div class="layui-input-block">
                                    <ul id="img-list">
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                    </ul>
                                </div>
                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_top">栏目内是否置顶</label>
                                    <input type="radio" id="is_top" name="is_top" value="on">是
                                    <input type="radio" id="is_top" name="is_top" checked value="">否
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="is_hot">推荐到首页</label>
                                    <input type="radio" id="show" name="is_hot" value="on">是
                                    <input type="radio" id="show" name="is_hot" value="" checked>否
                                </div>
                            </div>

                            {{--<div class="col-md-12">--}}

                                {{--<div class="form-group">--}}
                                    {{--<label for="is_slide">是否为轮播</label>--}}
                                    {{--<input type="checkbox" id="show" name="is_slide" value="">是--}}
                                    {{--<input type="checkbox" id="show" name="is_slide" checked value="">否--}}

                                {{--</div>--}}
                            {{--</div>--}}

                            {{--<div class="col-md-12">

                                <div class="form-group">
                                    <label for="role">类别</label>
                                    <div class="input-group ">

                                        @foreach($subclasses as $subclass)
                                            <div class="checkbox">
                                                <label class="radio-inline">
                                                    <input type="checkbox" name="class_id" value="{{$subclass->id}}">
                                                    <span class="mr5" style="margin-right: 20px;">{{$subclass->title}}</span>
                                                </label>
                                            </div>
                                        @endforeach

                                    </div>
                                </div>

                            </div>--}}


                            <div class="col-md-12">

                                <div class="form-group has-success">
                                    <label for="slug">标签</label>
                                    <input type="text" name="tags" class="form-control is-valid" value="" placeholder="标签">
                                    <div class="layui-form-mid layui-word-aux">多标签新闻，标签之间请用“ , ”隔开。</div>
                                </div>

                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sort">排序（正序）</label>
                                    <input type="number" class="form-control" id="sort" placeholder="排序" min="0" value="0">
                                </div>

                            </div>

                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="digest"><span class="x-red">*</span>摘要</label>
                                    <textarea class="form-control" name="digest" id="digest" rows="5" placeholder="摘要"></textarea>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">描述</label>
                                    <script id="editor" name="body" name="description" type="text/plain"></script>
                                    {{--<input type="text" class="form-control" id="description" name="description" placeholder="描述">--}}
                                </div>
                            </div>


                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="share_content"><span class="x-red">*</span>分享介绍</label>
                                    <textarea class="form-control" name="share_content" id="share_content" rows="5" placeholder="请输入分享简介"></textarea>
                                </div>
                            </div>

                        </div>

                        <button type="submit" onclick="addPrivilege(0);" class="btn btn-general btn-blue mr-2">保存并返回
                        </button>
                        <button type="submit" onclick="addPrivilege(10);" class="btn btn-general btn-white">提交审核
                        </button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')
<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{asset('fileupload/js/vendor/jquery.ui.widget.js')}}"></script>
<script src="{{asset('fileupload/js/jquery.fileupload.js')}}"></script>

{{--<script type="text/javascript" charset="utf-8" src="{{ asset('xadmin/extra/utf8-php/ueditor.config.js') }}"></script>--}}
{{--<script type="text/javascript" charset="utf-8" src="{{ asset('xadmin/extra/utf8-php/ueditor.all.js') }}"></script>--}}
{{--<!--建议手动加在语言，避免在ie下有时因为加载语言失败导致编辑器加载失败-->--}}
{{--<!--这里加载的语言文件会覆盖你在配置项目里添加的语言类型，比如你在配置项目里配置的是英文，这里加载的中文，那最后就是中文-->--}}
{{--<script type="text/javascript" charset="utf-8" src="{{ asset('xadmin/extra/utf8-php/lang/zh-cn/zh-cn.js') }}"></script>--}}
@include('admin.news.uditor')

<!--Core Javascript -->
<script type="text/javascript">

    var ue = UE.getEditor('editor', {
        initialFrameWidth: 800,
        initialFrameHeight: 400,
    });

    ue.ready(function () {
        //因为Laravel有防csrf防伪造攻击的处理所以加上此行
        ue.execCommand('serverparam', '_token', '{{ csrf_token() }}');
    });


    function addPrivilege(control) {

        $("#form1").validate({
            rules: {
                title: {
                    required: true,
                    minlength: 2
                },
                password: {
                    link: true,
                    minlength: 5
                },
                author: {
                    required: true,
                },
                share_content: {
                    required: true,
                    // minlength:10,
                },
                origin:{
                    required:true,
                }
            },
            messages: {
                title: {
                    required: "标题不能为空",
                    minlength: "标题最小长度为2"
                },
                author: {
                    required: '作者不能为空'
                },
                share_content: {
                    required: "分享内容不能为空",
                    //minlength: "Your password must be at least 5 characters long"
                },
                origin:{
                    required:'新闻来源不能为空'
                }
            },
            submitHandler: function (form) {
                var form = document.querySelector("#form1");
                var formdata = new FormData(form);
                console.log('control', control)
                formdata.append('st', control);

                console.log('form',form)

                var class_ids = [];
                $('input:checkbox:checked').each(function(){
                    class_ids.push($(this).val())
                })
                formdata.append('class_id',class_ids.join(','));

                fetch_response('POST', '/web/news', formdata).then(function (res) {
                    if (res.code == 200) {
                        console.log('dsfsfsd', res)
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {
                            if (control == 0) {
                                window.location.href = '/web/mynews';
                            } else {
                                window.location.href = '/web/progressing_news';
                            }
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });


            },
            invalidHandler: function (form, validator) {
                console.log('fomr', form)
                return false;
            }

        });

    }



</script>
</body>

</html>