<!DOCTYPE html>
<html>

<head>

@include('admin.common.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <style>
        form.cmxform label.error, label.error {
            /* remove the next line when you have trouble in IE6 with labels in list */
            color: red;
            font-style: italic;
            margin-top: 11px;
        }
    </style>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <!--***** FORM GROUP *****-->
                <div class="card form" id="form5">
                    <div class="card-header">
                        <h3>编辑媒资</h3>
                    </div>
                    <br>
                    <form id="newForm">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        {{ method_field('PUT')}}

                        <div class="form-group">
                            <label for="media_name">媒资名称</label>
                            <div class="input-group ">
                                <div class="input-group-addon"><i class="icon iconfont icon-title">&#xe62b;</i></div>
                                <input type="text" class="form-control" name="media_name" id="media_name"
                                       placeholder="媒资名称" value="{{$media['media_name']}}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="exampleSelect1">媒资类别</label>
                            <select class="form-control" id="exampleSelect1" name="media_type">

                                @foreach($media_types as $media_type)

                                    @if($media_type['name'] == $media['media_type'])
                                        <option value="{{$media['media_type_id']}}" selected>{{$media_type['name']}}</option>
                                    @else
                                        <option value="{{$media['media_type_id']}}">{{$media_type['name']}}</option>
                                    @endif

                                @endforeach

                            </select>
                        </div>


                        {{--<div class="form-group">--}}
                            {{--<label for="mobile">电话号码</label>--}}
                            {{--<div class="input-group ">--}}
                                {{--<div class="input-group-addon"><i class="fa fa-phone"></i></div>--}}
                                {{--<input type="text" class="form-control" name="mobile" id="mobile"--}}
                                       {{--placeholder="电话号码" value="123456">--}}
                            {{--</div>--}}
                        {{--</div>--}}

                        <div class="form-group">
                            <label for="mobile">媒资视频链接</label>
                            <div class="input-group ">
                                <div class="input-group-addon"><i class="iconfont">&#xe746;</i></div>
                                <input type="text" class="form-control" name="media_url" id="media_url" value="{{$media['media_url']}}"
                                       placeholder="视频链接">
                            </div>
                        </div>


                        <div class="form-group">
                            <label class="access-key">公钥</label>
                            <textarea class="form-control" name="access_key" id="access-key" rows="5" placeholder="公钥">{{$media['access_key']}}</textarea>
                        </div>

                        <div class="form-group">
                            <label class="secret-key">私钥</label>
                            <textarea class="form-control" name="secret_key" id="secret-key" rows="5" placeholder="私钥">{{$media['secret_key']}}</textarea>
                        </div>

                        <button type="submit" onclick="registerUser();" class="btn btn-general btn-blue mr-2">确认</button>
                        <button type="reset" onclick="cancle()" class="btn btn-general btn-white">取消</button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}


<!--Core Javascript -->
<script type="text/javascript">


    function registerUser() {

        $("#newForm").validate({
            rules: {
                name: {
                    required: true,
                    minlength: 2
                },
                // password: {
                //     required: true,
                //     minlength: 5
                // },
                // confirm_password: {
                //     required: true,
                //     minlength: 5,
                //     equalTo: "#password"
                // },
                // email: {
                //     required: true,
                //     email: true
                // },
            },
            messages: {
                name: {
                    required: "媒资名称不能为空",
                    minlength: "Your username must consist of at least 2 characters"
                },
                // password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long"
                // },
                // confirm_password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long",
                //     equalTo: "Please enter the same password as above"
                // },
                //email: "Please enter a valid email address",
            },
            submitHandler: function (form) {
                var form = document.querySelector("#newForm");
                var formdata = new FormData(form);

                console.log("formdata",formdata)

                fetch_response('POST',"/web/media_manager/{{$media['_id']}}", formdata).then(function (res) {
                    if (res.code == 200) {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {
                            window.location.href = '/web/media_manager';
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });
            }
        });

    }

    function cancle() {
        $('body').toast({
            position: 'fixed',
            content: '已取消',
            duration: 1000,
            top: '50%'
        });
        setTimeout(function () {
            window.history.back();
        }, 2000)
    }

</script>
</body>

</html>