<?php

namespace App\Model;

use App\Exceptions\DatabaseException;
use Illuminate\Support\Facades\DB;
use Jenssegers\Mongodb\Eloquent\Model as Eloquent;

class UserModel extends Eloquent
{
    /**
     * mongodb collection 名字
     */
    protected $collection = 'users';

    protected $connection = 'mongodb';  //使用mongodb

    protected $primaryKey = '_id';

    /*
     * 获取用户列表
     */
    public static function getUserList(){

        try{

//            $str = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
//
//            for ($i = 0;$i<50;$i++){
//
//                $data = [
//                    'name'  => substr(str_shuffle($str),5,10),
//                    'create_time'   => date('Y-m-d H:i:s',time()),
//                    'status'    => 0,
//                    'password'  => md5(123456)
//                ];
//
//                DB::connection("mongodb")->collection("users")->insertGetId($data);
//
//            }
//            die;



            $users = DB::connection('mongodb')->collection('users')
                ->paginate(10);


//            dd($users);die;
            foreach ( $users as $user){
                $idArr = ($user['_id'])->jsonSerialize();
                $user['_id'] = $idArr['$oid'];
            }

        }catch (\Exception $exception){
            throw new DatabaseException($exception->getMessage());
        }

        return $users;
    }

    /**
     * 更新用户状态
     * @param $request
     * @return mixed
     * @throws DatabaseException
     */
    public static function updateUserStatus($request){

        $id = $request->id;

        try{
            $user = UserModel::find($id);
            if (empty($user)){
                throw new \Exception('用户不存在');
            }
            $isshow=$user->status==1?0:1;
            $flag = UserModel::where('_id',$id)->update(['status'=>$isshow]);
            if (!$flag){
                throw new \Exception("更新失败");
            }

        }catch (\Exception $exception){
            throw new DatabaseException($exception->getMessage());
        }
        return $flag;
    }

    /**
     * 获取用户基本信息
     * @param $id
     * @return mixed
     * @throws DatabaseException
     */
    public static function getUserInfoById($id){
        try{
            $user = DB::connection("mongodb")->collection("users")->find($id);

        }catch (\Exception $exception){
            throw new DatabaseException($exception->getMessage());
        }
        return $user;
    }

    /**
     * 更新用户信息
     * @param $request
     * @return mixed
     * @throws DatabaseException
     */
    public static function createOrUpdateUser($request){

        $id = $request->id;

        try{
            $user = UserModel::find($id);
            if (empty($user)){
                throw new \Exception('用户不存在');
            }

            $flag = UserModel::where('_id',$id)->update(array_merge([
                'status'    => $request->status? 1 :0,
            ],$request->all()));

            if (!$flag){
                throw new \Exception("更新失败");
            }
        }catch (\Exception $exception){
            throw new DatabaseException($exception->getMessage());
        }
        return $flag;
    }

    /**
     * 根据id删除用户
     * @param $id
     * @return mixed
     * @throws \Exception
     */
    public static function deleteUserById($id){
        try{
            $user = UserModel::find($id);

            if (empty($user)){
                throw new \Exception('用户不存在');
            }
            $flag = UserModel::where('_id',$id)->delete();

        }catch (\Exception $exception){
            throw new \Exception($exception->getMessage());
        }
        return $flag;

    }


}
