<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Tool\SrsHookValidate;
use Illuminate\Http\Request;
use App\Model\UserModel;
use App\Exceptions\ControllerException;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class MemberController extends Controller
{

    /**
     * users表单验证
     */
    protected $users_add_verify = [
        'name'     => 'required|unique:users',
        'password' => 'required|string|min:6,max:16',
    ];

    /**
     * users跟新验证
     */
    protected $users_update_verify = [
        'id'      => 'required',
        'name'    => 'required',
        'status'  => ''
    ];

    /**
     * 返回错误提示
     */
    protected $users_error_tips = [
        'name.required'     => '用户名不能为空',
        'name.unique'       => '用户名已存在',

        'password.required' => '密码为6到16位',
        'password.min'      => '密码为6到16位',
        'password.max'      => '密码为6到16位',
    ];

    /**
     * 管理员列表
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws ControllerException
     */
    public function index(Request $request)
    {

        $users = UserModel::getUserList($request);

        return view('admin.member.member_list', [
            'users'      => $users,
            'start_time' => substr($request->start_time, 0, 10),
            'end_time'   => substr($request->end_time, 0, 10),
            'name'       => $request->name,
            'STATUS'     => ['启用','停用'],
        ]);
    }


    /**
     * 会员添加
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws ControllerException
     */
    public function create()
    {

        return view('admin.member.member_add');
    }

    /**
     * 添加保存
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws ControllerException
     */
    public function store(Request $request)
    {
        //print_r(Auth::guard('web')->check());die;

        handler_drive(function () use ($request) {

            var_dump($request->all());die;

            $id = UserModel::createUser($request);
            #绑定角色
            if ($request->role_id) {
                UserModel::bandingRole($id, $request->role_id);
            }
            #跟新type
//            if ($this->user['name'] == self::ADMINISTRATOR_NAME) {
//                UserModel::updateUserType($id);
//            }
        });

        return success();
    }

    /**
     * 会员查看 不存在这个页面
     * @param $id
     */
    public function show($id)
    {

        abort(404);
    }

    /**
     * 会员编辑
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws ControllerException
     */
    public function edit($id)
    {

        $user = UserModel::getUserInfoById($id);

        return view('admin.member.member_edit', [
            'info' => $user,
        ]);
    }

    /**
     * 编辑保存
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws ControllerException
     * @throws \App\Exceptions\FormException
     */
    public function update(Request $request,$id)
    {
        handler_drive(function () use ($request,$id) {

            SrsHookValidate::srsHookCallback($request, $this->users_update_verify);

            if (!$this->checkOwnHandle($id)) {
                throw new \App\Exceptions\FormException('你不能操作别人的');
            }

            if ($id == getAdmin()->_id) {
                throw new \App\Exceptions\FormException('你不能操作你自己');
            }

            UserModel::createOrUpdateUser($request);

        });

        return success();
    }


    /**
     * 启用-停用
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws ControllerException
     * @throws \App\Exceptions\FormException
     */
    public function disable(Request $request,$id)
    {

        if (!$this->checkOwnHandle($id)) {
            throw new \App\Exceptions\FormException('你不能操作别人的');
        }

        if ($id == getAdmin()->_id) {
            throw new \App\Exceptions\FormException('你不能操作你自己');
        }
        UserModel::updateUserStatus($request);
        return success();
    }


    /**
     * 密码修改
     * @param $id
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\JsonResponse|\Illuminate\View\View
     * @throws ControllerException
     * @throws \App\Exceptions\FormException
     */
    public function password($id, Request $request)
    {
        if (request()->isMethod('post')) {
            if (!$this->checkOwnHandle($request->id)) {
                throw new \App\Exceptions\FormException('你不能操作别人的');
            }
            handler_drive(function () use ($request) {
                SrsHookValidate::srsHookCallback($request, [
                    'id'       => 'required',
                    'password' => 'required|string',
                    'repass'   => 'required|same:password',
                ], false, [
                    'id.required'       => '用户id必须',
                    'password.required' => '密码为6到16位',
                    'repass.required'   => '确认密码',
                    'repass.same'       => '两次密码不一致',
                ]);
                //dd($this->user);
                $rand = $this->user['rand'];
                //echo $rand;
                //exit;
                //$request->password = bcrypt($request->password);
                $request->password = md5($request->password.$rand);

                $request->tvpw = $request->password;
                UserModel::forgotPassword($request);
            });
            return success();
        }

        return view('admin.member.member_password', [
            'user' => UserModel::find($id),
        ]);
    }


    /**
     * 会员删除
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\FormException
     */
    public function destroy($id)
    {
        handler_drive(function () use ($id) {
            if (!$this->checkOwnHandle($id)) {
                throw new \App\Exceptions\FormException('你不能操作别人的');
            }

            if ($id == getAdmin()->_id) {
                throw new \App\Exceptions\FormException('你不能操作你自己');
            }
            UserModel::deleteUserById($id);
        });

        return success();
    }


    /**
     * 检测是否自己操作自己添加的用户
     * @param $user_id
     * @return bool
     */
    public function checkOwnHandle($user_id)
    {

        $user = getAdmin();

        if ($user->name != config('custom.supper_admin.name')) {

            $result = UserModel::find($user_id);

            if ($result === null) {
                return false;
            }

            if (!$user->user_type) {
                return false;
            }
        }
        return true;
    }
}
