<?php

namespace App\Http\Controllers\Web;

use App\Model\MediaCategoryModel;
use App\Model\MediaModel;
use App\Tool\SrsHookValidate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MediaController extends Controller
{
    public function index(Request $request){

        $medias = MediaModel::mediaList($request);

        return view('admin.media.media_list', [
            'medias'      => $medias,
            'start_time' => substr($request->start_time, 0, 10),
            'end_time'   => substr($request->end_time, 0, 10),
            'name'       => $request->name,
            'STATUS'     => ['启用','停用'],
        ]);

    }

    /**
     * 编辑房间
     * @param Request $request
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws \App\Exceptions\ControllerException
     */
    public function edit(Request $request,$id){

        $media = handler_drive(function () use ($request,$id){
            return MediaModel::getMediaDetail($id);
        });
        $media_types = MediaCategoryModel::catgList($request);

        return view('admin.media.media_edit', [
            'media'         => $media,
            'media_types'   => $media_types
        ]);

    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function update(Request $request,$id){

        $res = handler_drive(function () use ($request,$id){
            return MediaModel::updateMedia($request,$id);
        });
        return success($res);
    }

    /**
     * 显示
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws \App\Exceptions\ControllerException
     */
    public function create(Request $request){

        $reslut = handler_drive(function () use($request){
            $media_types = MediaCategoryModel::catgList($request);
            return $media_types;
        });

        $data['media_types'] = $reslut;
        $data['media_id'] = 'mda-'.generateRandomNum(16);
        return view('admin.media.media_add',$data);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function store(Request $request){

        $id = handler_drive(function () use($request){

            SrsHookValidate::srsHookCallback($request,[
                'media_name'  => 'required',
                'media_type'  => 'required',
                'media_id'    => 'required',
                'access_key'  => '',
                'secret_key'  => '',
                'media_url'   => 'required',
            ]);

            return MediaModel::hookRestoreMedia($request);

        });

        return success($id);
    }

}
