<?php

namespace App\Http\Controllers\Api\Client;

use App\Model\MediaModel;
use App\Model\QiniuModel;
use App\Tool\SrsHookValidate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Qiniu\Config;
use Qiniu\Storage\FormUploader;

class MediaController extends Controller
{
    private $bucketList = [
        'develop'  => 'dev-offcncloud',
        'test'     => 'test-offcncloud',
        'master'   => 'offcncloud',
    ];

    /**
     * 获取媒资ID
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function index(Request $request){

        $result = handler_drive(function () use ($request) {
            return ["mediaID" => 'mda-'.generateRandomNum(16)];
        });
        return success($result);
    }

    /**
     * 获取上传媒资token
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function getUploadMediaToken(Request $request){

        $result = handler_drive(function () use ($request) {
            $branch = empty(getenv('branch')) ? 'test' : getenv('branch');

            SrsHookValidate::srsHookCallback($request,[
               'key'    => ''
            ]);

            $key = $request->key??null;

            $token = QiniuModel::uploadToken($this->bucketList[$branch],$key);

            return ["token" => $token];
        });
        return success($result);
    }

    /**
     * 视频上传成功之后，回调重新上传
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function hookRestoreMedia(Request $request){

//        $this->testUploadFile($request);

        $id = handler_drive(function () use ($request) {

            SrsHookValidate::srsHookCallback($request,[
                'media_name'  => 'required',
                'media_type'  => 'required',
                'media_id'    => 'required',
                'access_key'  => '',
                'secret_key'  => '',
                'media_url'   => 'required',
            ]);

            $id = MediaModel::hookRestoreMedia($request);

            return $id;
        });
        return success($id);
    }

    /**
     * 更新媒资信息
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function updatehookMedia(Request $request,$id){


        $id = handler_drive(function () use($request,$id){

            SrsHookValidate::srsHookCallback($request,[
                'media_name'    => 'required',
                'media_type' => 'required',
                'media_id'      => 'required',
                'access_key'    => '',
                'secret_key'    => '',
                'media_url'     => 'required',
            ]);

            MediaModel::updatehookMedia($request,$id);

            return $id;
        });
        return success($id);
    }



    /**
     * 测试上传文件
     * @param Request $request
     */
    function testUploadFile(Request $request){

        $token = $token = QiniuModel::uploadToken($this->bucketList['test']);
        $file = $request->file('file_name');

        $conf = new Config();
        $res = FormUploader::putFile($token,$file->getFilename(),$file->getRealPath(),$conf,null,null);

        var_dump($res);die;


    }


}
