<!DOCTYPE html>
<html>

@include('admin.common_bak.commonMedia')
<link href="{{ asset('xadmin/extra/bootstrap-datetimepicker-master/css/bootstrap-datetimepicker.min.css')}}" rel="stylesheet" media="screen">

<body>

<!--====================================================
                         MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                        PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner chart-cont">

        <div class="card form">
            <div class="card-header">
                <h3><i class="fa fa-user-circle"></i> 已发布列表</h3>
            </div>
            <br>

            <!--***** CONTENT *****-->
            <div class="row" style="margin: 0 20px;">

                <div class="xblock">

                    <form method="get">
                        {{--<a class="btn btn-primary" href="/web/news/create">添加</a>--}}
                        <input type="text" class="form-input" autocomplete="off" name="title" value="{{$title}}" placeholder="搜索">
                        <!-- <select class="form-input" id="exampleSelect1">
                            <option>1</option>
                            <option>2</option>
                            <option>3</option>
                            <option>4</option>
                            <option>5</option>
                        </select> -->


                        <button type="submit" class="btn btn-primary">搜索</button>
                    </form>
                    <span style="display: inline-block;height: 40px;line-height: 40px; float: right">共{{$news_contents->total()}} 条</span>

                </div>


                <table class="table" id="test">
                    <thead>
                    <tr>
                        <th>
                            <div class="layui-unselect header layui-form-checkbox" lay-skin="primary">
                                <i class="layui-icon">&#xe605;</i></div>
                        </th>
                        <th>状态</th>
                        <th>新闻标题</th>
                        {{--<th>作者</th>--}}
                        {{--<th>新闻来源</th>--}}
                        <th>所属栏目</th>
                        <th>最新时间</th>
                       {{-- <th>浏览量</th>--}}
                        <th>栏目<br>排序</th>
                        <th>首页<br>置顶</th>
                        <th>首页<br>排序</th>
                        <th>操作</th>
                    </thead>
                    <tbody>
                    @if(count($news_contents)>0)
                        @foreach ($news_contents as $k => $news_content)
                            <tr>
                                <td>
                                    <div class="layui-unselect layui-form-checkbox" lay-skin="primary"
                                         data-id='{{$news_content->id}}'><i class="layui-icon ">&#xe605;</i></div>
                                </td>
                                {{--<td>{{$news_content->id}}</td>--}}
                                <td>
                                    @include('admin.news.auditstatus')
                                </td>
                                <td>
                                    {{--点击一下置顶，取消置顶，点击一下轮播，取消轮播--}}
                                    @if($news_content->is_top == 'y')
                                        <font style="color: red" title="新闻置顶状态">[顶]</font>
                                    @endif
                                    @if($news_content->is_slide == 'y' && $news_content-> slide_type == 'home')
                                        <font style="color: red" title="新闻首页轮播">[首轮]</font>
                                    @endif
                                    @if($news_content->is_slide == 'y' && $news_content-> slide_type == 'column')
                                        <font style="color: red" title="新闻《{{$news_content->news_categories->title}}》栏目轮播">[栏轮]</font>
                                    @endif
                                    @if($news_content->is_hot == 'y' )
                                        <font style="color: red" title="此条新闻为热门推荐新闻">[推荐]</font>
                                    @endif
                                    <a href="/web/newsdetail/{{$news_content->id}}?action=news_pass" title="{{$news_content->title}}">{{str_limit($news_content->title,40,'')}}</a>
                                </td>
                                <td>{{$news_content->news_categories->title}}</td>
                                <td class="dbclicktd" data-id="{{$news_content->id}}"  title="{{$news_content->new_datetime}}">

                                    @if(Auth::user()->name==config('custom.supper_admin.name'))
                                        <input class="form-control form_datetime" style="background-color:#fff;border:none;" type="text" value="{{$news_content->new_datetime}}" id="{{$news_content->id}}" readonly>
                                    @else

                                        {{$news_content->new_datetime}}
                                        {{--@ifHasPermission('news.modified_news_datetime')--}}
                                        {{--<input class="form-control" type="text" value="{{$news_content->new_datetime}}" id="{{$news_content->id}}" readonly/>--}}
                                        {{--@endIfHasPermission--}}
                                    @endif
                                </td>
                               {{-- <td class="dbclicktd" ondblclick="sort_edit(this,'view_count')"
                                    data-id="{{$news_content->id}}">{{$news_content->view_count}}</td>--}}
                                <td class="dbclicktd" ondblclick="sort_edit(this,'sort')"
                                    data-id="{{$news_content->id}}">{{$news_content->sort}}</td>
                                <td>
                                    @if($news_content->hot_top =='y')<font color="red">是</font>@else否@endif
                                </td>
                                <td class="dbclicktd" ondblclick="sort_edit(this,'hot_sort')"
                                    data-id="{{$news_content->id}}">{{$news_content->hot_sort}}</td>


                                <td class="td-manage">
                                    @if(Auth::user()->name==config('custom.supper_admin.name'))
                                        <a title="编辑" href="/web/news/{{$news_content->id}}/edit?action=news_pass">
                                            <i class="iconfont">&#xe609;</i>
                                        </a>
                                        <a title="删除" onclick="member_del(this,'{{$news_content->id}}')"
                                           href="javascript:;">
                                            <i class="iconfont">&#xe695;</i>
                                        </a>

                                        <a href="/web/newsdetail/{{$news_content->id}}?action=news_pass" title="查看详情">
                                            <i class="iconfont">&#xe600;</i>
                                        </a>
                                        {{--<a title=""--}}
                                           {{--onclick="is_top(this,'{{$news_content->id}}','is_top','{{$news_content->is_top}}')"--}}
                                           {{--href="javascript:;">--}}
                                            {{--@if($news_content->is_top=='y')--}}
                                                {{--<button class="layui-btn layui-btn-xs layui-btn-normal"--}}
                                                        {{--title="此新闻在栏目已经置顶">栏已顶--}}
                                                {{--</button>--}}
                                            {{--@else--}}
                                                {{--<button class="layui-btn layui-btn-xs" title="此新闻栏目未置顶">栏未顶</button>--}}
                                            {{--@endif--}}
                                        {{--</a>--}}
                                        <a title="" onclick="is_top(this,'{{$news_content->id}}','is_hot','{{$news_content->is_hot}}')" href="javascript:;">
                                            @if($news_content->is_hot=='y')
                                                <i class="iconfont">&#xe689;</i>
                                            @else
                                                <i class="iconfont">&#xe79e;</i>
                                            @endif
                                        </a>
                                    @else
                                        <a href="/web/newsdetail/{{$news_content->id}}?action=news_pass" title="查看详情">
                                            <i class="iconfont">&#xe600;</i>
                                        </a>
                                    @endif

                                    {{--<a title="" onclick="is_top(this,'{{$news_content->id}}','is_slide','{{$news_content->is_slide}}')" href="javascript:;">
                                      @if($news_content->is_slide=='y')
                                        <button class="layui-btn layui-btn-xs layui-btn-normal">已轮播</button>
                                      @else
                                        <button class="layui-btn layui-btn-xs">未轮播</button>
                                      @endif
                                    </a>--}}
                                    {{--<a title="修改浏览量" href="javascript:;" onclick="x_admin_show('修改浏览量','/web/news/changeViewCount/{{$news_content->id}}/{{$news_content->view_count}}/{{$news_content->title}}',400,300)"   >--}}
                                    {{--<i class="layui-icon">&#xe69e;</i>--}}
                                    {{--</a>--}}
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="10" style="text-align:center">暂无数据</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
                <div class="page">
                    <div>
                        {{$news_contents->appends(['start_time'=>$start_time,'end_time'=>$end_time,'title'=>$title,'category_id'=>$category_id])->links()}}
                    </div>
                </div>

            </div>
        </div>


    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')

<!--Core Javascript -->
<link rel="stylesheet" href="{{ asset('xadmin/extra/jqueryConfirm/css/jquery-confirm.css')}}">
<script src="{{ asset('xadmin/extra/jqueryConfirm/js/jquery-confirm.min.js')}}"></script>

<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>
<script src="{{ asset('xadmin/js/bootstrap.min.js')}}"></script>


{{--<link rel="stylesheet" href="{{ asset('xadmin/css/bootstrap.min.css')}}">--}}

<script type="text/javascript">

    /*权限-删除*/
    function member_del(row, id) {


        $.confirm({
            // confirmButtonClass: 'btn-info',
            // cancelButtonClass: 'btn-info',
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            confirmButton: '确认',
            cancelButton: '取消',
            content:'确认要删除吗？',


            confirm: function () {
                fetch_response('DELETE', "/web/news/" + id).then(function (res) {
                    $('body').toast({
                        position: 'fixed',
                        content: res.msg,
                        duration: 1000,
                        top: '50%'
                    });
                    setTimeout(function () {
                        window.location.href = '/web/news_pass';
                    }, 2000)
                })

            },
            cancel: function () {
                $('body').toast({
                    position:'fixed',
                    content:'已取消',
                    duration:1000,
                    top:'50%'
                });
            }
        });
    }
    function is_top(obj,news_id,type,st){

        var flag = 'y';
        var msg = '确认设置新闻为审核通过';
        var text = '已审核';

        switch (type){
            case 'is_top':
                if (st=='y'){
                    msg = '确认从置顶中移除？';
                    flag = 'n';
                    text = '未置顶';
                }else{
                    msg = '确认加入置顶？';
                    flag = 'y';
                    text = '已置顶';
                }
                break;

            case 'is_slide':
                if (st=='y'){
                    msg = '确认从轮播中移除？';
                    flag = 'n';
                    text = '未轮播';
                }else{
                    msg = '确认加入轮播？';
                    flag = 'y';
                    text = '已轮播';
                }
            case 'is_hot':
                if (st=='y'){
                    msg = '确认从首页推荐中移除？';
                    flag = 'n';
                    text = '推未顶';
                }else{
                    msg = '确认设置为首页推荐？';
                    flag = 'y';
                    text = '推已顶';
                }
                break;
        }


        $.confirm({
            // confirmButtonClass: 'btn-info',
            // cancelButtonClass: 'btn-info',
            cancelButtonClass: 'btn-info',
            confirmButtonClass: 'btn-danger',
            confirmButton: '确认',
            cancelButton: '取消',
            content:'确认要'+msg,


            confirm: function () {


                var opts = new FormData();

                opts.append('news_id', news_id);
                opts.append('st', flag);
                opts.append('type', type);

                //发异步删除数据

                fetch_response('POST','/web/news/is_top',opts).then(function(response){
                    console.log('response',response)

                    if (response['code'] == 200) {

                        $('body').toast({
                            position: 'fixed',
                            content: response.msg,
                            duration: 1000,
                            top: '50%'
                        });

                    } else {

                        $('body').toast({
                            position:'fixed',
                            content:response.msg,
                            duration:1000,
                            top:'50%'
                        });

                    }
                })

            },
            cancel: function () {
                $('body').toast({
                    position:'fixed',
                    content:'已取消',
                    duration:1000,
                    top:'50%'
                });
            }
        });
    }


</script>

<script src="{{ asset('xadmin/extra/bootstrap-datetimepicker-master/js/bootstrap-datetimepicker.js')}}"></script>
{{--<script src="{{ asset('xadmin/extra/bootstrap-datetimepicker-master/js/locales/bootstrap-datetimepicker.fr.js')}}"></script>--}}
<script src="{{ asset('xadmin/extra/bootstrap-datetimepicker-master/js/locales/bootstrap-datetimepicker.zh-CN.js')}}"></script>
<script type="text/javascript">


    $('.form_datetime').datetimepicker({
        //language:  'fr',
        // weekStart: 1,
        todayBtn:  1,
        autoclose: 1,
        todayHighlight: 1,
        format:'yyyy-mm-dd hh:ii:ss',
        startView: 2,
        language:  'zh-CN',
        // initialDate:new Date()
        // forceParse: 0,
        // showMeridian: 1
    }).on('changeDate', function(ev){


        //console.log('ev.date.valueOf()',ev.date.valueOf())

        var news_id = $(ev.currentTarget).attr('id')

        var time = ev.date.valueOf();
        time = formatDateTime(time);


        var opts = new FormData();

        opts.append('id', news_id);
        opts.append('new_datetime',time)

        //发异步删除数据

        fetch_response('POST','/web/modified_news_datetime',opts).then(function(response){
            //console.log('response',response)

            if (response['code'] == 200) {

                $('body').toast({
                    position: 'fixed',
                    content: response.msg,
                    duration: 1000,
                    top: '50%'
                });

            } else {

                $('body').toast({
                    position:'fixed',
                    content:response.msg,
                    duration:1000,
                    top:'50%'
                });

            }
        })




    });



</script>

</body>

</html>

