<!DOCTYPE html>
<html>

<head>

@include('admin.common_bak.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <link rel="stylesheet" href="{{ asset('xadmin/css/news/edit_news.css')}}">
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i> {{$title}}</h3>
                    </div>
                    <br>
                    <form id="form1">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title">新闻标题</label>
                                    <input type="text" class="form-control" name="title" readonly value="{{$news->title}}" id="title" placeholder="新闻标题">
                                </div>
                                <div class="form-group">
                                    <label for="link">文章作者</label>
                                    <input type="text" class="form-control" id="link" readonly value="@if($news->author!=''){{$news->author}}@else佚名@endif" name="link" placeholder="文章作者">
                                </div>

                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="icon">新闻来源</label>
                                    <input type="text" class="form-control" id="icon" readonly name="icon" value="{{$news->origin}}" placeholder="新闻来源">
                                </div>

                                <div class="form-group has-success">
                                    <label for="web_url">新闻外链地址</label>
                                    <input type="text" class="form-control is-valid" name="web_url" id="web_url" readonly value="{{$news->web_url}}" placeholder="新闻外链地址">
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label for="icon">栏目类别</label>
                                    <input type="text" class="form-control" id="icon" readonly name="icon" value="{{$category->title}}" placeholder="新闻来源">
                                </div>

                            </div>

                            {{--<div class="col-md-12">--}}

                                {{--<div class="form-group">--}}
                                    {{--<label class="fileupload">多图新闻图片上传</label>--}}
                                    {{--<div class="layui-input-block">--}}
                                        {{--<input type="file" multiple id="fileupload" name="uploadfile" value=""/>--}}
                                        {{--<input type="hidden" id = "fileuploadImg" name="images" value=""/>--}}
                                        {{--<div class="layui-form-mid layui-word-aux">如果是多图新闻，请上传3张图片，每张500k以内；否则不用上传</div>--}}

                                    {{--</div>--}}
                                {{--</div>--}}

                            {{--</div>--}}

                            {{--<div class="col-md-6">--}}

                                {{--<div class="form-group has-success">--}}
                                    {{--<label for="slug">上级</label>--}}
                                    {{--<input type="hidden" name="superior_ids" class="form-control is-valid"--}}
                                           {{--value="{{$user_id}}" readonly="">--}}

                                    {{--<input type="text" class="form-control is-valid" value="{{$username}}" readonly="">--}}
                                {{--</div>--}}

                            {{--</div>--}}

                            {{--<div class="col-md-12">--}}
                                {{--<label class="layui-form-label">多图新闻图片预览</label>--}}
                                {{--<div class="layui-input-block">--}}
                                    {{--<ul id="img-list">--}}
                                        {{--@if(isset($news->imgs)&&!empty($news->imgs))--}}
                                            {{--@foreach($news->imgs as $img)--}}
                                                {{--<li><img src="{{ $img }}" alt="" class="mul-pic"></li>--}}
                                            {{--@endforeach--}}
                                        {{--@endif--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                    {{--</ul>--}}
                                {{--</div>--}}
                            {{--</div>--}}

                            <div class="col-md-12">
                                <label class="layui-form-label">多图新闻图片预览</label>
                                <div class="layui-input-block">
                                    <ul id="img-list">
                                        @if(isset($news->imgs)&&!empty($news->imgs))
                                            @foreach($news->imgs as $img)
                                                <li style="margin-left: 20px;"><img src="{{ $img }}" alt="" class="mul-pic"></li>
                                            @endforeach
                                        @endif
                                    </ul>
                                </div>
                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_top">栏目内是否置顶</label>
                                    <input type="radio" id="show" name="is_top" @if($news->is_top=='y') checked @endif value="on">是
                                    <input type="radio" id="show" name="is_top"  @if($news->is_top=='n') checked @endif value="">否
                                </div>
                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_hot">推荐到首页</label>
                                    <input type="radio" id="show" name="is_hot" @if($news->is_hot=='y') checked @endif value="on">是
                                    <input type="radio" id="show" name="is_hot"  @if($news->is_hot=='n') checked @endif value="">否
                                </div>
                            </div>

                            {{--<div class="col-md-12">--}}

                                {{--<div class="form-group">--}}
                                    {{--<label for="is_top">是否置顶</label>--}}
                                    {{--<input type="radio" disabled id="show" name="is_top" value="">是--}}
                                    {{--<input type="radio" disabled id="show" name="is_top" checked value="">否--}}
                                {{--</div>--}}
                            {{--</div>--}}

                            {{--<div class="col-md-12">--}}

                                {{--<div class="form-group">--}}
                                    {{--<label for="is_slide">是否为轮播</label>--}}
                                    {{--<input type="radio" disabled id="show" name="is_slide" value="">是--}}
                                    {{--<input type="radio" disabled id="show" name="is_slide" checked value="">否--}}

                                {{--</div>--}}
                            {{--</div>--}}

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="class_id">类别</label>
                                    <div class="input-group">
                                        {{--<input type="hidden" name="class_id" id="class_id">--}}

                                        @foreach($subclasses as $subclass)


                                            @if(isset($news->class_id)&&$news->class_id)
                                                <div class="checkbox">

                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" disabled="" value="{{$subclass->id}}" @if(in_array($subclass->id,explode(',',$news->class_id))) checked @endif>
                                                        <span class="mr5" style="margin-right: 20px;">{{$subclass->title}}</span>
                                                    </label>
                                                </div>
                                            @else
                                                <div class="checkbox">
                                                    <label class="checkbox-inline">
                                                        <input type="checkbox" disabled="" value="{{$subclass->id}}">
                                                        <span class="mr5" style="margin-right: 20px;">{{$subclass->title}}</span>
                                                    </label>
                                                </div>
                                            @endif
                                        @endforeach

                                    </div>
                                </div>

                            </div>

                            <div class="col-md-12">

                                <div class="form-group has-success">
                                    <label for="slug">标签</label>
                                    <input type="text" name="tags" class="form-control is-valid" value="{{$news->tags}}" disabled placeholder="标签">
                                    <div class="layui-form-mid layui-word-aux">多标签新闻，标签之间请用“ , ”隔开。</div>
                                </div>

                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sort">排序（正序）</label>
                                    <input type="number" class="form-control" id="sort" readonly placeholder="排序" min="0" value="{{$news->sort}}">
                                </div>

                            </div>

                            <div class="col-md-9">
                                <div class="form-group">
                                    <label class="digest"><span class="x-red">*</span>摘要</label>
                                    <textarea class="form-control" name="digest" id="digest" rows="5" placeholder="摘要">{{$news->digest}}</textarea>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">描述</label>
                                    {{--<script id="editor" name="body" name="description" type="text/plain"></script>--}}
                                    <script id="editor" name="body" type="text/plain" readonly>
                                        <?php
                                        echo html_entity_decode($news->body, 1)
                                        ?>
                                    </script>
                                    {{--<input type="text" class="form-control" id="description" name="description" placeholder="描述">--}}
                                </div>
                            </div>


                            <div class="col-md-9" >
                                <div class="form-group">
                                    <label class="share_content"><span class="x-red">*</span>分享介绍</label>
                                    <textarea readonly class="form-control" name="share_content" id="share_content" required   placeholder="请输入分享简介" >{{$news->share_content}}</textarea>
                                </div>
                            </div>

                        </div>

                        <button type="button" onclick="addPrivilege();" class="btn btn-general btn-blue mr-2">返回</button>
                    </form>
                    <table class="table table-striped" style="margin-top: 20px;" >
                        <thead>
                        <tr>
                            <th>执行人</th>
                            {{--<th>下一步执行人</th>--}}
                            <th>执行时间</th>
                            {{--<th>结束时间</th>--}}
                            <th>执行结果</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($newsLogs as $log)
                            <tr>
                                <td>{{$log->user_name}}</td>
                                {{--<td>{{$log->next_user_name}}</td>--}}
                                <td>{{$log->created_at}}</td>
                                {{--<td>{{$log->end_datetime}}</td>--}}
                                <td>{{$log->title}}：{{$log->suggestions}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
{{--<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>--}}

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}


@include('admin.news.uditor')

<!--Core Javascript -->
<script type="text/javascript">

    var ue = UE.getEditor('editor',{
        initialFrameWidth : 800,
        initialFrameHeight: 400,
    });

    ue.ready(function(){
        //因为Laravel有防csrf防伪造攻击的处理所以加上此行
        ue.setDisabled();
        {{--ue.execCommand('serverparam','_token','{{ csrf_token() }}');--}}
    });


    function addPrivilege() {
        window.location.href = '/web/{{$action}}';
    }

</script>
</body>
</html>