<!DOCTYPE html>
<html>

<head>

@include('admin.common_bak.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <style>

        .hide{
            display: none;
        }
        .show{
            display: block;
        }
        .mul-pic{
            width: 100px;
            height: 60px;
        }
    </style>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common_bak.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common_bak.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i> 添加新闻</h3>
                    </div>
                    <br>
                    <form id="form1">
                        {{ method_field('PUT') }}
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title">新闻标题</label>
                                    <input type="text" class="form-control" name="title" value="{{$news->title}}" id="title" placeholder="新闻标题">
                                </div>
                                <div class="form-group">
                                    <label for="author">文章作者</label>
                                    <input type="text" class="form-control" name="author" id="author" value="@if($news->author!=''){{$news->author}}@else佚名@endif" name="link" placeholder="文章作者">
                                </div>

                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="origin">新闻来源</label>
                                    <input type="text" class="form-control" id="origin" name="origin" value="{{$news->origin}}" placeholder="新闻来源">
                                </div>

                                <div class="form-group has-success">
                                    <label for="web_url">新闻外链地址</label>
                                    <input type="text" class="form-control is-valid" name="web_url" id="web_url" value="{{$news->web_url}}" placeholder="新闻外链地址">
                                </div>
                            </div>

                            <div class="col-md-6">

                                <div class="form-group">
                                    <label for="pid">栏目类别</label>
                                    <select class="form-control" name="category_id" id="pid">
                                        {{--<option value="0">请选择栏目</option>--}}
                                        @foreach($categories as $key => $category)
                                            @if(isset($category->childCag)&&!empty($category->childCag))
                                                <optgroup label="{{$category->title}}">
                                                    @foreach($category->childCag as $childCag)
                                                        <option value="{{$childCag['id']}}" <?php if($news->category_id==$childCag['id']) echo 'selected'?>>{{$childCag['title']}}</option>
                                                    @endforeach
                                                </optgroup>
                                            @else
                                                <option value="{{$category->id}}" <?php if($news->category_id==$category->id) echo 'selected'?>>{{$category->title}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label class="fileupload">多图新闻图片上传</label>
                                    <div class="layui-input-block">
                                        <input type="file" multiple id="fileupload" name="uploadfile" value=""/>
                                        <input type="hidden" id = "fileuploadImg" name="images" value=""/>
                                        <div class="layui-form-mid layui-word-aux">如果是多图新闻，请上传3张图片，每张500k以内；否则不用上传</div>

                                    </div>
                                </div>

                            </div>

                            <div class="col-md-6 hide">
                                <label class="layui-form-label">多图新闻图片预览</label>
                                <div class="layui-input-block">
                                    <ul id="img-list">
                                        @if(isset($news->imgs)&&!empty($news->imgs))
                                            @foreach($news->imgs as $img)
                                                <li><img src="{{ $img }}" alt="" class="mul-pic"><a onclick="delPic(this)">删除</a></li>
                                            @endforeach
                                        @endif
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                        {{--<li><img src="{{ asset('images/403.png') }}" alt=""></li>--}}
                                    </ul>
                                </div>
                            </div>


                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_top">是否置顶</label>
                                    <input type="radio" id="show" name="is_top" value="">是
                                    <input type="radio" id="show" name="is_top" checked value="">否
                                </div>
                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="is_slide">是否为轮播</label>
                                    <input type="radio" id="show" name="is_slide" value="">是
                                    <input type="radio" id="show" name="is_slide" checked value="">否

                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="sort">排序（正序）</label>
                                    <input type="number" class="form-control" id="sort" placeholder="排序" min="0" value="0">
                                </div>

                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">描述</label>
                                    {{--<script id="editor" name="body" name="description" type="text/plain"></script>--}}
                                    <script id="editor" name="body" type="text/plain">
                                        <?php
                                        echo html_entity_decode($news->body, 1)
                                        ?>
                                    </script>
                                    {{--<input type="text" class="form-control" id="description" name="description" placeholder="描述">--}}
                                </div>
                            </div>


                            <div class="col-md-7" >
                                <div class="form-group">
                                    <label class="share_content"><span class="x-red">*</span>分享介绍</label>
                                    <textarea class="form-control" name="share_content" id="share_content" required   placeholder="请输入分享简介" >{{$news->share_content}}</textarea>
                                </div>
                            </div>

                        </div>

                        <button type="submit" onclick="addPrivilege(5);" class="btn btn-general btn-blue mr-2">驳回</button>
                        <button type="submit" onclick="addPrivilege(40);" class="btn btn-general btn-white">通过</button>
                    </form>
                    <table class="table table-striped" style="margin-top: 20px;" >
                        <thead>
                        <tr>
                            <th>执行人</th>
                            {{--<th>下一步执行人</th>--}}
                            <th>执行时间</th>
                            {{--<th>结束时间</th>--}}
                            <th>执行结果</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($newsLogs as $log)
                            <tr>
                                <td>{{$log->user_name}}</td>
                                {{--<td>{{$log->next_user_name}}</td>--}}
                                <td>{{$log->created_at}}</td>
                                {{--<td>{{$log->end_datetime}}</td>--}}
                                <td>{{$log->title}}：{{$log->suggestions}}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common_bak.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}

<script src="{{asset('fileupload/js/vendor/jquery.ui.widget.js')}}"></script>
<script src="{{asset('fileupload/js/jquery.fileupload.js')}}"></script>

<script type="text/javascript" charset="utf-8" src="{{ asset('laravel-u-editor/ueditor.config.js') }}"></script>
<script type="text/javascript" charset="utf-8" src="{{ asset('laravel-u-editor/ueditor.all.min.js') }}"> </script>
<!--建议手动加在语言，避免在ie下有时因为加载语言失败导致编辑器加载失败-->
<!--这里加载的语言文件会覆盖你在配置项目里添加的语言类型，比如你在配置项目里配置的是英文，这里加载的中文，那最后就是中文-->
<script type="text/javascript" charset="utf-8" src="{{ asset('laravel-u-editor/lang/zh-cn/zh-cn.js') }}"></script>


<!--Core Javascript -->
<script type="text/javascript">

    var ue = UE.getEditor('editor',{
        initialFrameWidth : 800,
        initialFrameHeight: 400,
    });

    ue.ready(function(){
        //因为Laravel有防csrf防伪造攻击的处理所以加上此行
        ue.execCommand('serverparam','_token','{{ csrf_token() }}');
    });


    function addPrivilege(control) {

        $("#form1").validate({
            rules: {
                name: {
                    required: true,
                    minlength: 2
                },
                password: {
                    link: true,
                    minlength: 5
                },
                slug: {
                    required: true,
                },
                // email: {
                //     required: true,
                //     email: true
                // },
            },
            messages: {
                name: {
                    required: "Please enter a username",
                    minlength: "Your username must consist of at least 2 characters"
                },
                // password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long"
                // },
                // confirm_password: {
                //     required: "Please provide a password",
                //     minlength: "Your password must be at least 5 characters long",
                //     equalTo: "Please enter the same password as above"
                // },
                slug: "Please enter a valid slug",
            },
            submitHandler: function (form) {
                var form = document.querySelector("#form1");
                var formdata = new FormData(form);

                formdata.append('st',control);

                fetch_response('PUT', '/web/news/{{$news->id}}', formdata).then(function (res) {
                    if (res.code == 200) {
                        console.log('dsfsfsd',res)
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {
                            window.location.href = '/web/mynews';
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });


            },
            invalidHandler: function(form, validator) {
                console.log('fomr',form)
                return false;
            }

        });

    }

    var img_list = [];

    /*jslint unparam: true */
    /*global window, $ */
    $(function () {
        'use strict';
        // Change this to the location of your server-side upload handler:


        $('#fileupload').fileupload({
            url: '/web/newsUpload',
            dataType: 'json',
            done: function (e, data) {
                var file_img = data.result.data.file_path;

                // $('<li><img src="'+file_img+'"></li>').appendTo('#img-list');
                $('<li><img src="'+file_img+'" class="mul-pic"><a onclick="delPic(this)">删除</a></li>').appendTo('#img-list');

                img_list.push(file_img);

                $('#fileuploadImg').attr("value",img_list.join(','));

                if (img_list.length){
                    $('#img-list').parent().parent().removeClass('hide');
                    $('#img-list').parent().parent().addClass('show');
                }

                //console.log('img_list',img_list);
            },
            progressall: function (e, data) {
                var progress = parseInt(data.loaded / data.total * 100, 10);
                $('#progress .progress-bar').css(
                    'width',
                    progress + '%'
                );
            }
        }).prop('disabled', !$.support.fileInput)
            .parent().addClass($.support.fileInput ? undefined : 'disabled');
    });

    function picViewer(id,show,delid) {
        var r= new FileReader();
        var imgurl =document.getElementById(id).files[0];


        r.readAsDataURL(imgurl);
        r.onload=function (e) {
            document.getElementById(show).src=this.result;
            document.getElementById(delid).style.visibility = 'visible';
        };
    }
    function delLocalPic(id,show,delid) {
        document.getElementById(id).value='';
        document.getElementById(show).src='';
        document.getElementById(delid).style.visibility = 'hidden';
    }

    function delPic(pic){

        $(pic).parent().remove();

        var imglist=$("#img-list img");
        var img_list = [];


        for(var i=0;i<imglist.length;i++){
            if(imglist[i].getAttribute('src')){
                img_list.push(imglist[i].getAttribute('src'));
            }
        }
        // console.log('=========',img_list)
        $('#fileuploadImg').attr("value",img_list.join(','));

        if (img_list.length==0){
            $('#img-list').parent().parent().removeClass('show');
            $('#img-list').parent().parent().addClass('hide');
        }

        // console.log("$('#fileuploadImg')",$('#fileuploadImg').val())

    }

    //批量审核
    function check_mul_news_yes(ids) {
        layer.confirm('您确认要审核通过吗？',function(){
            var aa = layer.load(1);
            fetch_response('GET','/web/news/check_mul_news_yes/'+ids)
                .then(function(response){
                    if (response['code'] == 200) {
                        layer.close(aa);
                        layer.msg('审核通过',{icon:6},function(){
                            window.location.reload();
                        });
                    } else {
                        layer.close(i);
                        layer.msg('审核失败:'+response.msg,{icon:5})
                    }
                })
        });
    }
    //批量审核
    function check_mul_news_no() {
        var data = tableCheck.getData();
        if (data.length==0){
            layer.msg('请选择数据！',{icon:5});
            return;
        }
        console.log('data',data);
        layer.confirm('您确认要驳回审核吗？',function(){
            var ids = data.join('_');
            //发异步删除数据
            var i = layer.load(1);
            fetch_response('GET','/web/news/check_mul_news_no/'+ids)
                .then(function(response){
                    if (response['code'] == 200) {
                        layer.close(i);
                        layer.msg('驳回成功',{icon:6},function(){
                            window.location.reload();
                        });
                    } else {
                        layer.close(i);
                        layer.msg('驳回失败:'+response.msg,{icon:5})
                    }
                })
        });
    }

</script>
</body>
</html>