<!DOCTYPE html>
<html>

<head>

@include('admin.common.commonMedia')
<!-- Core stylesheets -->
    <link rel="stylesheet" href="{{ asset('xadmin/css/form.css')}}">
    <style>
        form.cmxform label.error, label.error {
            /* remove the next line when you have trouble in IE6 with labels in list */
            color: red;
            font-style: italic;
            margin-top: 11px;
        }
    </style>
</head>

<body>

<!--====================================================
                     MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                    PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner form-cont">
        <div class="row">
            <div class="col-md-12">

                <div class="card form">
                    <div class="card-header">
                        <h3><i class="fa fa-user-circle"></i> 编辑栏目</h3>
                    </div>
                    <br>
                    <form id="form1">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        {{ method_field('PUT') }}
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name">栏目名称</label>
                                    <input type="text" class="form-control" name="name" value="{{$mediaCatg['name']}}" id="name" placeholder="栏目名称">
                                </div>
                                <input type="hidden" name="id" value="{{$mediaCatg['id']}}"/>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="media_category_id">appID</label>
                                    <input type="text" class="form-control" name="media_category_id" value="{{$mediaCatg['media_category_id']}}" id="media_category_id" placeholder="appID" readonly>
                                </div>
                            </div>

                            <div class="col-md-12">

                                <div class="form-group">
                                    <label for="status">启用：</label>
                                    <input type="radio" id="status" name="status" @if($mediaCatg['status']=='0') checked @endif value="0">是
                                    <input type="radio" id="status" name="status" @if($mediaCatg['status']=='1') checked @endif value="1">否
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">描述</label>
                                    <textarea type="text" class="form-control" id="description" name="description" placeholder="描述" cols="30" rows="10" value="{{$mediaCatg['description']}}"></textarea>
                                </div>
                            </div>

                        </div>

                        <button type="submit" onclick="addPrivilege();" class="btn btn-general btn-blue mr-2">保存</button>
                        <button type="reset" class="btn btn-general btn-white">取消</button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')


<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>
<script src="{{ asset('xadmin/js/jquery.validate.js')}}"></script>

{{--<link rel="stylesheet" href="{{ asset('xadmin/extra/toast/css/toast.css')}}">--}}


<!--Core Javascript -->
<script type="text/javascript">


    function addPrivilege() {

        $("#form1").validate({
            rules: {
                name: {
                    required: true,
                    minlength: 2
                },

            },
            messages: {
                name: {
                    required: "栏目名称不能为空",
                    minlength: "栏目名称至少两个字符"
                },

            },
            submitHandler: function (form) {
                var form = document.querySelector("#form1");
                var formdata = new FormData(form);

                fetch_response('POST', "/web/media_category/{{$mediaCatg['id']}}", formdata).then(function (res) {
                    if (res.code == 200) {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                        setTimeout(function () {
                            window.location.href = '/web/media_category';
                        }, 2000)

                    } else {
                        $('body').toast({
                            position: 'fixed',
                            content: res.msg,
                            duration: 1000,
                            top: '50%'
                        });
                    }
                });


            },
            invalidHandler: function(form, validator) {
                console.log('fomr',form)
                return false;
            }

        });

    }

</script>
</body>

</html>