<!DOCTYPE html>
<html>
@include('admin.common.commonMedia')

<link rel="stylesheet" href="{{asset('xadmin/extra/date/datepicker.css')}}">
<script src="{{ asset('xadmin/extra/date/datepicker.js')}}"></script>
<script src="{{ asset('xadmin/extra/date/datepicker.zh-CN.js')}}"></script>
<body>

<!--====================================================
                         MAIN NAVBAR
======================================================-->
@include('admin.common.header')

<!--====================================================
                        PAGE CONTENT
======================================================-->
<div class="page-content d-flex align-items-stretch">

    <!--***** SIDE NAVBAR *****-->
    @include('admin.common.left')

    <div class="content-inner chart-cont">

        <div class="card form">
            <div class="card-header">
                <h3><i class="fa fa-user-circle"></i> 批处理</h3>
            </div>
            <br>

            <!--***** CONTENT *****-->
            <div class="row ml20 batch-list">

                <form>
                    {{ method_field('POST')}}

                    <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                    <div class="item-name">批量导出预览视频连接</div>

                    <div class="form-group">
                        <input type="file" class="btn btn-info" id="uploadFile" name="uploadFile" accept=".xls,.xlsx">
                    </div>
                    <button class="btn btn-info batch-media" type="button" id="batch-media" disabled onclick="test()" >导出</button>

                </form>

                <div class="muban">
                    <span class="btn btn-info btn-small"><a href="{{asset('/web/media_manager/export_batch_media?type=muban')}}">模板文件</a></span>


                </div>

                <div class="notice">
                    注意事项：
                    <ul>
                        <li>导入数据最多不超过200条，超出部分自动被过滤掉！</li>
                    </ul>
                </div>

            </div>
        </div>


    </div>
</div>

<!--Global Javascript -->
@include('admin.common.foot')

<!--Core Javascript -->
<script src="{{ asset('xadmin/extra/toast/js/toast.js')}}"></script>


<style>
    .form{
        min-height: 734px;
    }
    .batch-list{
        font-size: 18px;
        font-weight: 400;
    }
    .batch-media{
        margin-top: 10px;
    }
    .muban{
        padding-top: 30px;
        padding-left: 10px;
    }
    .muban a{
        color: #eee;
    }
    .notice{
        padding-left: 20%;
        color: #ff5f75;
        font-size: 14px;
    }
</style>
<script>
    /**
     * 点击上传文件，触发input type="file"
     */
    $("#uploadFile").change(function () {
        $("#batch-media").removeAttr("disabled");
        var fileInput = $('#uploadFile').get(0).files[0];
        if (fileInput === undefined){
            $("#batch-media").attr("disabled",true);
        }
    })

    /**
     * 清空页面属性
     */
    function test() {


        var formData = new FormData();
        formData.append("uploadFile",$("#uploadFile")[0].files[0]);


        $.ajax({
            url:'/web/media_manager/import_batch_media', /*接口域名地址*/
            type:'post',
            data: formData,
            processData: false,
            contentType: false,
            success:function(res){
                if(res.code === 200){

                    $('body').toast({
                        position: 'fixed',
                        content: '导入成功，数据处理中......',
                        duration: 3000,
                        top: '50%'
                    });
                    window.location.href = "/web/media_manager/download/"+res.data
                }else {
                    $('body').toast({
                        position: 'fixed',
                        content: res.msg,
                        duration: 3000,
                        top: '50%'
                    });
                }
                $("#batch-media").attr("disabled",true);
                $("#uploadFile").val("")
            }
        })



        // $('body').toast({
        //     position: 'fixed',
        //     content: '导入成功，数据处理中......',
        //     duration: 3000,
        //     top: '50%'
        // });
        // setTimeout(function () {
        //     $("#batch-media").attr("disabled",true);
        //     $("#uploadFile").val("")
        // }, 2000)
    }

</script>

</body>

</html>