<?php

namespace App\Http\Controllers\Web;

use App\Model\MediaCategoryModel;
use App\Tool\SrsHookValidate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MediaCategoryController extends Controller
{
    public function index(Request $request){

        $result = handler_drive(function () use ($request) {


            $catgList = MediaCategoryModel::catgListPage($request);
            return $catgList;
        });
        $data['name'] = $request->name;
        $data['media_categories'] = $result;


        return view('admin.media_category.list',$data);
    }


    /**
     * 会员添加
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @throws ControllerException
     */
    public function create()
    {
        return view('admin.media_category.add');
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function store(Request $request){

        handler_drive(function () use($request){

            SrsHookValidate::srsHookCallback($request,[
                'name'              => 'required',
                'media_category_id' => 'required',
                'status'            => '',
                'description'       => ''
            ]);

            MediaCategoryModel::addMediaCatg($request);

        });
        return success();
    }

    /**
     * 显示查看媒资详情
     * @param Request $request
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(Request $request,$id){

        $mediaCatg = MediaCategoryModel::where("_id",$id)->first();

        $data['mediaCatg'] = $mediaCatg;

        return view('admin.media_category.edit',$data);
    }

    /**
     * @param Request $request
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function update(Request $request,$id){


        handler_drive(function () use($request,$id){

            SrsHookValidate::srsHookCallback($request,[
                'name'              => 'required',
                'media_category_id' => 'required',
                'status'            => '',
                'description'       => '',
            ]);


            MediaCategoryModel::updateMediaCatg($request,$id);

        });
        return success();

    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \App\Exceptions\ControllerException
     */
    public function disable(Request $request)
    {
        handler_drive(function () use($request){

            $id = $request->id;

            SrsHookValidate::srsHookCallback($request,[
                'status'        => '',
                'id'            => ''
            ]);

            MediaCategoryModel::disable($request,$id);

        });

        return success();
    }

}
