package com.offcn.im.demo.adapter;

import android.content.Context;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.jyall.base.adapter.BaseRecyclerViewAdapter;
import com.jyall.base.adapter.RecyclerViewHolderUtil;
import com.offcn.im.demo.R;
import com.offcn.im.demo.bean.UserBean;

import java.util.List;

public class ContactAdapter extends BaseRecyclerViewAdapter<UserBean> {
    public ContactAdapter(Context paramContext) {
        super(paramContext);
    }

    public ContactAdapter(Context context, List<UserBean> list) {
        super(context, list);
    }

    @Override
    public int onCreateViewLayoutID(int i) {
        return R.layout.item_contact_child;
    }

    @Override
    public void bindItemViewHolder(RecyclerViewHolderUtil recyclerViewHolderUtil, int i) {
        UserBean item = getItem(i);
        TextView title = recyclerViewHolderUtil.get(R.id.tv_name);
        ImageView avatar = recyclerViewHolderUtil.get(R.id.iv_avatar);
        title.setText(item.getName());
        Glide.with(mContext).load(item.getAvatar()).placeholder(R.mipmap.ic_teacher).into(avatar);
    }
}
