package com.offcn.im.demo;

import android.content.Context;

import com.jyall.base.util.EventBusCenter;
import com.jyall.base.util.EventBusUtil;
import com.jyall.base.util.ValidateUtils;
import com.offcn.im.demo.bean.UserBean;
import com.offcn.im.demo.util.Constants;
import com.offcn.im.demo.util.LoginManager;
import com.offcn.im.demo.util.MockData;
import com.offcn.live.im.OIMCallback;
import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMMsg;
import com.offcn.live.im.bean.OIMUserInfo;
import com.offcn.live.im.util.OIMDataManager;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.imkit.OIMKitSDK;
import com.tencent.bugly.crashreport.CrashReport;

import androidx.multidex.MultiDex;
import androidx.multidex.MultiDexApplication;

public class MyApp extends MultiDexApplication {
    private static final String TAG = MyApp.class.getSimpleName();

    // 设置当前环境
    private boolean mEnvIsTest = false;

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();

        Constants.ENV_IS_TEST = mEnvIsTest;
        // 初始化 OIMSDK
        initOIMSDK();
        // bugly
        CrashReport.initCrashReport(getApplicationContext(), "8e4fbab19e", true);
    }

    private void initOIMSDK() {
        // 中公IM 初始化
        OIMSDK.init(this, mEnvIsTest);
        // 中公IM 初始化UI相关配置
        OIMKitSDK.init(this);
        // 打印log 方便调试------------------记得上线前关闭
        ZGLLogUtils.setLogEnabled(BuildConfig.DEBUG);
        // 中公IM 监听新消息。默认不用监听，如有需求要监听新消息，可实现此方法
        OIMSDK.getInstance().setOnMsgListener(new OIMCallback.OnReceiveMsgListener() {
            @Override
            public void onMsg(OIMMsg oimMsg) {
                ZGLLogUtils.e(TAG, "onMsg 新消息");
            }
        });
        // 中公IM 监听未读总数变化
        OIMSDK.getInstance().setOnUnreadMsgCountChangedListener(new OIMCallback.OnUnreadMsgCountChangedListener() {
            @Override
            public void onCountChanged(int i) {
                ZGLLogUtils.e(TAG, "未读总数变化：" + i);
            }
        });
        // 中公IM 提供用户信息
        OIMSDK.getInstance().setUserInfoProvider(new OIMCallback.OnUserInfoProvider() {
            @Override
            public OIMUserInfo getUserInfo(String s) {
                if (ValidateUtils.isEmpty(s)) {
                    return null;
                }

                // 获取用户信息，返回给SDK。建议外部DB存储用户信息
                UserBean destUserBean = MockData.getUserById(s);
                if (destUserBean == null) {
                    return null;
                }
                OIMUserInfo userInfo = new OIMUserInfo();
                userInfo.setUser_id(destUserBean.getUser_id());
                userInfo.setRemark("");
                userInfo.setName(destUserBean.getName());
                userInfo.setAvatar(destUserBean.getAvatar());
                return userInfo;
            }

            @Override
            public OIMUserInfo getUserInfoPm(String s, String s1) {
                return null;
            }
        });
    }
}
