package com.offcn.im.demo.ui;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.offcn.live.im.OIMSDK;
import com.offcn.live.im.bean.OIMMsg;
import com.offcn.live.im.bean.OIMMsgBody;
import com.offcn.live.im.bean.OIMSendTypeEnum;
import com.offcn.live.im.bean.OIMSessionTypeEnum;
import com.offcn.live.im.util.ZGLLogUtils;
import com.offcn.live.im.util.ZGLParseUtils;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

/**
 * 推送通知栏点击处理类
 */
public class PushTranslateActivity extends AppCompatActivity {
    private static final String TAG = PushTranslateActivity.class.getSimpleName();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        String content = null;
        Bundle bundle = getIntent().getExtras();
        if (bundle != null) {
            content = bundle.getString("content");
        }
        if (!TextUtils.isEmpty(content)) {
            // 跳转到聊天页面需要保证 OIMSDK 连接成功，所以建议先跳转到应用首页进行全局初始化操作
            ZGLLogUtils.e(TAG, "push : " + content);
            startActivity(new Intent(this, SplashActivity.class));


            //  以下为根据推送类型判断启动页面，如单聊消息、系统通知 等

//            OIMMsg oimMsg = ZGLParseUtils.parseObjectByGson(content, OIMMsg.class);
//            if (oimMsg != null) {
//                if (oimMsg.getType() == OIMSessionTypeEnum.P2P.getType()) {
//                    // 会话类型为单聊。跳转到聊天页面需要保证 OIMSDK 连接成功，所以建议先跳转到应用首页进行全局初始化操作
//                    OIMMsgBody msgBody = oimMsg.getBody();
//                    if (msgBody != null) {
//                        OIMSDK.getInstance().startChat(
//                                this,
//                                OIMSendTypeEnum.PRIVATE,
//                                msgBody.getMsg_from(),
//                                OIMSDK.getInstance().getUserInfo(msgBody.getMsg_from()).getName(),    // 发送者名称。当前未作空判断
//                                0);
//                    }
//                } else if (oimMsg.getType() == OIMSessionTypeEnum.GROUP.getType()) {
//                    // 群聊。2021年1月19日 暂未支持群聊
//
//                } else {
//                    // 其它类型。比如系统通知
//
//                }
//            } else {
//
//            }

        }

        finish();
        overridePendingTransition(0, 0);
    }

}
